//
//  QGUserCenterDataModel.h
//  VirtualPayment
//
//  Created by 张博 on 2019/12/12.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"

NS_ASSUME_NONNULL_BEGIN

@class QGUserCenterMenuModel, QGUserCenterUserInfoModel;

@interface QGUserCenterDataModel : QGBaseModel

/// 菜单项
@property (nonatomic, strong) NSArray <QGUserCenterMenuModel *>* menus;

/// 用户信息
@property (nonatomic, strong) QGUserCenterUserInfoModel * userInfo;

@end


/// 菜单项
@interface QGUserCenterMenuModel : QGBaseModel

/// 文字标题
@property (nonatomic, strong) NSString * desc;

/// 图片
@property (nonatomic, strong) NSString * icon;

/// 跳转链接
@property (nonatomic, strong) NSString * jumpUrl;
@end


/// 用户信息相关
@interface QGUserCenterUserInfoModel : QGBaseModel
/**
账户状态：0-初始状态(未开通享花卡)，1-激活享花卡成功，2-激活享花卡失败，4-审核中，6-激活上银2类户成功 7-激活上银2类户失败
*/
@property (nonatomic, strong) NSString * accountStatus;

/**
 可再次申请日期
 */
@property (nonatomic, strong) NSString * refusedNextApplyTime;

/// 真实姓名
@property (nonatomic, strong) NSString * name;

/// 用户头像
@property (nonatomic, strong) NSString * headImage;


@end

NS_ASSUME_NONNULL_END
