//
//  QGPermissionViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/1/19.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGPermissionViewController.h"

//View
#import "QGPermissionHeaderCell.h"
#import "QGPermissionSetCell.h"

//Model
#import "QGPermissionModel.h"

//Tool
#import "AccessPermissionsManager.h"
#import <Photos/Photos.h>
#import <CoreLocation/CoreLocation.h>

#import "QGLocationManager.h"



@interface QGPermissionViewController ()<CLLocationManagerDelegate>

/// 数据源
@property (nonatomic, strong) NSMutableArray * dataArray;

@property (nonatomic, strong)CLLocationManager *location;
@end

@implementation QGPermissionViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self initNormal];
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(applicationBecomeActive) name:UIApplicationDidBecomeActiveNotification object:nil];
}

- (void)applicationBecomeActive
{
    [self resetDataSource];
}

- (void)initNormal
{
    self.title = @"授权管理";
    self.tableView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
    [self custemLeftDefaultBarButtonItem];
    
    [self resetDataSource];
}

/// 重置数据源
- (void)resetDataSource
{
    //数据源
       self.dataArray = [NSMutableArray arrayWithCapacity:1];
       @weakify(self);
       //相机
       AVAuthorizationStatus cameraStatus = [AVCaptureDevice authorizationStatusForMediaType:AVMediaTypeVideo];
       //是否同意了
       BOOL cameraIsAccess = cameraStatus == AVAuthorizationStatusAuthorized ? YES : NO;
       QGPermissionModel * cameraModel = [[QGPermissionModel alloc] initWithTitle:@"允许访问相机" isAccess:cameraIsAccess ruleString:@"方便您使用扫码、拍照、身份验证等服务。关于《访问相机》" clickRuleString:@"《访问相机》" ruleClickBlock:^{
           @strongify(self);
           [self navigationToWeb:CameraRuleUrl];
       } itemClickBlock:^{
           @strongify(self);
           //未设置过
           if (cameraStatus == AVAuthorizationStatusNotDetermined) {
               [AVCaptureDevice requestAccessForMediaType:AVMediaTypeVideo completionHandler:^(BOOL granted) {//相机权限
                   [self resetDataSource];
               }];
           }
           else
           {
               [self jumpSetting];
           }
       }];
       [self.dataArray addObject:cameraModel];
       
       //相册
       PHAuthorizationStatus photoAuthorStatus = [PHPhotoLibrary authorizationStatus];
       //是否同意了
       BOOL photoIsAccess = photoAuthorStatus == PHAuthorizationStatusAuthorized ? YES : NO;
       QGPermissionModel * photoModel = [[QGPermissionModel alloc] initWithTitle:@"允许访问相册" isAccess:photoIsAccess ruleString:@"方便您取用或上传图片与视频。关于《访问相册》" clickRuleString:@"《访问相册》" ruleClickBlock:^{
           @strongify(self);
           [self navigationToWeb:PhotoRuleUrl];
       } itemClickBlock:^{
           @strongify(self);
           //如果还未访问过权限，则弹出权限提示
           if (photoAuthorStatus == PHAuthorizationStatusNotDetermined) {
               [PHPhotoLibrary requestAuthorization:^(PHAuthorizationStatus status) {
                   [self resetDataSource];
               }];
           }
           else
           {
               [self jumpSetting];
           }
       }];
       [self.dataArray addObject:photoModel];
       
       //麦克风
       AVAuthorizationStatus microStatus = [AVCaptureDevice authorizationStatusForMediaType:AVMediaTypeAudio];//麦克风权限
       //是否同意了
       BOOL microIsAccess = microStatus == AVAuthorizationStatusAuthorized ? YES : NO;
       QGPermissionModel * microModel = [[QGPermissionModel alloc] initWithTitle:@"允许访问麦克风" isAccess:microIsAccess ruleString:@"方便您使用身份验证服务。关于《访问麦克风》" clickRuleString:@"《访问麦克风》" ruleClickBlock:^{
           @strongify(self);
           [self navigationToWeb:MicroPhoneRuleUrl];
       } itemClickBlock:^{
           @strongify(self);
           //如果还未访问过权限，则弹出权限提示
           if (microStatus == AVAuthorizationStatusNotDetermined) {
               [AVCaptureDevice requestAccessForMediaType:AVMediaTypeAudio completionHandler:^(BOOL granted) {//麦克风权限
                   [self resetDataSource];
               }];
           }
           else
           {
               [self jumpSetting];
           }
       }];
       [self.dataArray addObject:microModel];
    

    QGLocationManager *location = [QGLocationManager shareManager];
    
    location.statusBlock = ^(QGLocationStatus status) {
        @strongify(self);
        [self resetDataSource];
    };
    
    /// 地理位置是否可用
    if (location.status != QGLocationStatusNotAvaiable) {
        BOOL CLAccess = location.status == QGLocationStatusAuthed ? YES : NO;
      __block QGPermissionModel * locationModel = [[QGPermissionModel alloc] initWithTitle:@"允许访问位置信息"
                                                                            isAccess:CLAccess
                                                                          ruleString:@"为了向您推荐附近的服务。关于《位置信息》"
                                                                     clickRuleString:@"《位置信息》"
                                                                      ruleClickBlock:^{
            @strongify(self);
            [self navigationToWeb:kGPSRuleUrl];
        } itemClickBlock:^{
            @strongify(self);
            if (location.status == QGLocationStatusNotDetermined) {
                [location requestLocationAuthorizationStatus:NULL];
            }else{
                [self jumpSetting];
            }
        }];
        
        [self.dataArray addObject:locationModel];
    }
    
    dispatch_async(dispatch_get_main_queue(), ^{
        [self.tableView reloadData];
    });
    
}

- (void)locationManager:(CLLocationManager *)manager didChangeAuthorizationStatus:(CLAuthorizationStatus)status
{
    [manager stopUpdatingLocation];
    [self resetDataSource];
}


#pragma mark - UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    return 2;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    NSInteger numberOfRows = 0;
    switch (section) {
            //顶部标题
        case 0:
            numberOfRows = 1;
            break;
            //权限
        case 1:
            numberOfRows = self.dataArray.count;
        break;
            
        default:
            break;
    }
    return numberOfRows;
}


- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    switch (indexPath.section) {
            //顶部标题
        case 0:
        {
            QGPermissionHeaderCell * cell = (QGPermissionHeaderCell *)[self getCellFromClassName:NSStringFromClass([QGPermissionHeaderCell class]) dequeueTableView:tableView];
            return cell;
        }
            break;
        //权限设置项
        case 1:
        {
            QGPermissionSetCell * cell = (QGPermissionSetCell *)[self getCellFromClassName:NSStringFromClass([QGPermissionSetCell class]) dequeueTableView:tableView];
            cell.permissionModel = self.dataArray[indexPath.row];
            return cell;
        }
            break;
            
            
            
        default:
            break;
    }
    return [super tableView:tableView cellForRowAtIndexPath:indexPath];
}


#pragma mark - UITableViewDelegate
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.section == 1) {
        QGPermissionModel * model = self.dataArray[indexPath.row];
        if (model.itemClickBlock) {
            model.itemClickBlock();
        }
    }
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    CGFloat heightForRow = 0;
    switch (indexPath.section) {
            //顶部标题
        case 0:
            heightForRow = 58;
            break;
            //权限
        case 1:
        {
            QGPermissionModel * model = self.dataArray[indexPath.row];
            heightForRow = model.cellHeight;
        }
        break;
            
        default:
            break;
    }
    return heightForRow;
}

///跳转设置中心
- (void)jumpSetting
{
    NSURL *url = [NSURL URLWithString:UIApplicationOpenSettingsURLString];
    if([[UIApplication sharedApplication]canOpenURL:url]) {
        if (@available(iOS 10.0, *)) {
            [[UIApplication sharedApplication] openURL:url options:@{} completionHandler:nil];
        } else {
            [[UIApplication sharedApplication] openURL:url];
            // Fallback on earlier versions
        }
    }
}

- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

@end
