//
//  QGPermissionSetCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/1/19.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGPermissionSetCell.h"

#import "QGBasicUITool.h"
#import "ZHRichText.h"
@interface QGPermissionSetCell ()

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 状态
@property (nonatomic, strong) UILabel * statusLabel;

/// 协议富文本
@property (nonatomic, strong) ZHHitLabel * ruleLabel;
@end

@implementation QGPermissionSetCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.contentView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        //白色背景块
        UIView * whiteView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor whiteColor]];
        [whiteView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.inset(0);
            make.height.mas_equalTo(60);
        }];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:whiteView title:nil titleFontSize:[UIFont qg_lightFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.centerY.offset(0);
        }];
        
        //箭头
        UIImageView * arrowImgView = [UIImageView creatImageViewWithSuperView:whiteView imageName:@"cell_right_arrow"];
        [arrowImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(6, 12));
            make.right.inset(20);
            make.centerY.offset(0);
        }];
        
        //状态
        self.statusLabel = [UILabel creatLabelWithSuperView:whiteView title:@"设置权限" titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor mainThemeColor] alignment:NSTextAlignmentRight];
        [self.statusLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.mas_equalTo(arrowImgView.mas_left).offset(-8);
            make.centerY.offset(0);
        }];
        
        //协议
        self.ruleLabel = [[ZHHitLabel alloc] init];
        [self.contentView addSubview:self.ruleLabel];
        self.ruleLabel.numberOfLines = 0;
        [self.ruleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.mas_equalTo(whiteView.mas_bottom).offset(5);
        }];
        
        @weakify(self);
        self.ruleLabel.clickBlock = ^(ZHRichHelpModel *model) {
            @strongify(self);
            if(self.permissionModel.ruleClickBlock) {
                self.permissionModel.ruleClickBlock();
            }
        };
        
    }
    return self;
}


- (void)setPermissionModel:(QGPermissionModel *)permissionModel
{
    if (_permissionModel != permissionModel) {
        _permissionModel = permissionModel;
        
        self.titleLabel.text = _permissionModel.title;
        self.statusLabel.text = _permissionModel.isAccess ? @"已允许" : @"设置权限";
        self.statusLabel.textColor = _permissionModel.isAccess ? [UIColor textColor9999] : [UIColor mainThemeColor];
        self.ruleLabel.attributedText = [_permissionModel.ruleTool getResultString];
        
    }
}

@end
