//
//  QGPermissionModel.m
//  VirtualPayment
//
//  Created by 张博 on 2020/1/19.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGPermissionModel.h"
#import "QGBasicUITool.h"
@implementation QGPermissionModel

/// 初始化方法
/// @param title 标题
/// @param isAccess 权限状态
/// @param ruleString 协议
/// @param clickRuleString 可点击的协议
/// @param ruleClickBlock 规则点击事件
/// @param itemClickBlock 点击事件
-(instancetype)initWithTitle:(NSString *)title isAccess:(BOOL)isAccess ruleString:(NSString *)ruleString clickRuleString:(NSString *)clickRuleString ruleClickBlock:(dispatch_block_t)ruleClickBlock itemClickBlock:(dispatch_block_t)itemClickBlock
{
    if (self = [super init]) {
        self.title = title;
        self.isAccess = isAccess;
        self.ruleString = ruleString;
        self.clickRuleString = clickRuleString;
        self.ruleClickBlock = ruleClickBlock;
        self.itemClickBlock = itemClickBlock;
    }
    return self;
}

- (ZHAttributedLabelTool *)ruleTool
{
    if (!_ruleTool) {
        _ruleTool = [[ZHAttributedLabelTool alloc] initWithText:self.ruleString font:[UIFont qg_lightFontOfSize:12] color:[UIColor textColor6666]];
        [_ruleTool addRichHelpWithType:ZHRichHelpTypeClick range:[self.ruleString rangeOfString:self.clickRuleString] color:[UIColor mainThemeColor] font:[UIFont qg_lightFontOfSize:12]];
    }
    return _ruleTool;
}

- (CGFloat)cellHeight
{
    if (_cellHeight == 0) {
        _cellHeight = 60 + 5 + [self.ruleTool getSizeWithMaxWidth:MAINSCREEN_WIDTH - 20].height + 17;
    }
    return _cellHeight;
}

@end
