//
//  QGPermissionModel.h
//  VirtualPayment
//
//  Created by 张博 on 2020/1/19.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaseModel.h"
#import "ZHAttributedLabelTool.h"
NS_ASSUME_NONNULL_BEGIN

@interface QGPermissionModel : QGBaseModel

/// 标题
@property (nonatomic, strong) NSString * title;

/// 规则
@property (nonatomic, strong) NSString * ruleString;

/// 需要点击的规则字符串
@property (nonatomic, strong) NSString * clickRuleString;

/// 规则富文本
@property (nonatomic, strong) ZHAttributedLabelTool * ruleTool;

/// cell高度
@property (nonatomic, assign) CGFloat cellHeight;

/// 规则点击事件
@property (nonatomic, copy) dispatch_block_t ruleClickBlock;

/// cell点击事件
@property (nonatomic, copy) dispatch_block_t itemClickBlock;

/// 是否已允许
@property (nonatomic, assign) BOOL isAccess;


/// 初始化方法
/// @param title 标题
/// @param isAccess 权限状态
/// @param ruleString 协议
/// @param clickRuleString 可点击的协议
/// @param ruleClickBlock 规则点击事件
/// @param itemClickBlock 点击事件
-(instancetype)initWithTitle:(NSString *)title isAccess:(BOOL)isAccess ruleString:(NSString *)ruleString clickRuleString:(NSString *)clickRuleString ruleClickBlock:(dispatch_block_t)ruleClickBlock itemClickBlock:(dispatch_block_t)itemClickBlock;

@end

NS_ASSUME_NONNULL_END
