//
//  QGHelpCenterSelfServiceCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/27.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGHelpCenterSelfServiceCell.h"
#import "QGBasicUITool.h"
@interface QGHelpCenterSelfServiceCell ()

@property (nonatomic, strong)UIImageView *iconImageView;
@property (nonatomic, strong)UILabel *titleLabel;

@property (nonatomic, strong)UILabel *headerLabel;


@end

@implementation QGHelpCenterSelfServiceCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        //灰色view
        UIView *headerView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        
        
        self.headerLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"自助服务" titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
 
        self.iconImageView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:@"help_quota_image"];
        
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"提额" titleFontSize:[UIFont qg_lightFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        

        
        //灰色view
        UIView *bottomView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        
        
        
        
        [headerView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView);
            make.top.equalTo(self.contentView);
            make.height.mas_equalTo(10);
        }];
        
        
        
        
        [self.headerLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(20);
            make.top.equalTo(headerView).offset(20);
            make.height.mas_equalTo(25);
        }];
        
        
        [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.contentView).inset(32);
            make.top.equalTo(self.headerLabel.mas_bottom).offset(30);
            make.width.mas_equalTo(41);
            make.height.mas_equalTo(32);
        }];
        
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.equalTo(self.iconImageView.mas_centerX);
            make.top.equalTo(self.iconImageView.mas_bottom).offset(18);
            make.width.mas_equalTo(35);
            make.height.mas_equalTo(22);
        }];
        
        [bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView);
            make.bottom.equalTo(self.contentView);
            make.height.mas_equalTo(10);
        }];
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
    }
    return self;
}

@end
