//
//  QGFeedbackViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/27.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGFeedbackViewController.h"
#import "QGFeedbackQuestionTypeCell.h"
#import "QGQuestionTypeModel.h"
#import "QGFeedbackTextViewCell.h"
#import "QGFeedbackAddImageTableViewCell.h"
#import "QGFeedbackSubmitBtnTableViewCell.h"
#import "QGAlertView.h"
#import "QGUserCenterRequestApi.h"
@interface QGFeedbackViewController ()<UIGestureRecognizerDelegate>
///标签按钮的数组
@property (nonatomic, strong)NSMutableArray *buttonsArray;
///问题cell的高度
@property (nonatomic, assign)CGFloat cellHeight;
///问题信息的数组
@property (nonatomic, strong)NSMutableArray <NSDictionary *>*btnInfoArray;
///选中的反馈问题
@property (nonatomic, copy)NSDictionary *questionInfo;
///反馈的问题
@property (nonatomic, copy)NSString *feedbackStr;

///上传图片的URL拼接字符
@property (nonatomic, copy)NSString *imageURLStr;
///提交按钮的cell
@property (nonatomic, strong)QGFeedbackSubmitBtnTableViewCell *submitCell;
@end

@implementation QGFeedbackViewController
-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.title = @"意见反馈";
    [self setNavBarBottomLineHidden:YES];
    [self custemLeftDefaultBarButtonItem];
    //请求数据
    [self requestData];
    //添加隐藏键盘的手势
    UITapGestureRecognizer *tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(hideKeyboard)];
    tap.delegate = self;

    tap.numberOfTouchesRequired = 1;
    
    [self.view addGestureRecognizer:tap];
}
//隐藏键盘
-(void)hideKeyboard
{
    [self.view endEditing:YES];
}
- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldReceiveTouch:(UITouch *)touch

{
    
    
    
    // 输出点击的view的类名
    
    NSLog(@"%@", NSStringFromClass([touch.view class]));
    
    // 若为UIView（就是击了添加图片），则不截获Touch事件（就是继续执行Cell的点击方法）
    
    if ([NSStringFromClass([touch.view class]) isEqualToString:NSStringFromClass([UIView class])]) {
        
        return NO;
    }
    
    return YES;
    
}


#pragma mark request
///网络请求
- (void)requestData
{
    
    NSString *url = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodFeedbackType];

    @weakify(self);
    [QGHUDManager showHud:nil];
    
    [[QGTalosNetwork shareManager] GET:url parameters:nil success:^(id  _Nonnull responseObject) {
        @strongify(self);
        [QGHUDManager hideHud];
        //业务处理成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            self.btnInfoArray = responseObject[@"data"][@"suggestTypeList"];
            [self creatBtnWithArray:self.btnInfoArray];
            [self.tableView reloadData];
        }
        //业务处理失败
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
}

//提交意见反馈
-(void)submitFeedback
{
    if (self.feedbackStr.length<10) {
        [QGHUDManager showHud:@"请输入不少于10个字的描述"];
        return;
    }
    
    NSMutableDictionary *parame = [[NSMutableDictionary alloc]init];
    [parame setObject:self.questionInfo[@"id"] forKey:@"suggestType"];
    [parame setObject:self.feedbackStr forKey:@"msg"];
    
    if (![NSString isEmpty:self.imageURLStr]) {
        [parame setObject:self.imageURLStr forKey:@"url"];
    }
    
    NSString *url = [QGUserCenterRequestApi urlWithUserCenterRequestServerMethod:QGUserCenterRequestServerMethodFeedbackSubmit];
    
    [QGHUDManager showHud:nil];
    [[QGTalosNetwork shareManager] POST:url parameters:parame success:^(id  _Nonnull responseObject) {
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [QGHUDManager hideHud];
            
            //用户反馈成功
            QGAlertView *alert = [[QGAlertView alloc] initWithTitle:nil message:@"提交成功，我们会尽快处理~" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:^(NSInteger index) {
                if (index == 1) {
                    [self.navigationController popViewControllerAnimated:YES];
                }
            }];
            [alert showInView:self.view];
        }
        else
        {
            [QGHUDManager showHudWithError:responseObject];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
    
}

///根据网络请求数据创建问题标签数组
-(void)creatBtnWithArray:(NSArray *)titleArray
{
    
    for (NSDictionary *infoDic in titleArray) {
        
        UIButton *button = [UIButton creatButtonWithBordercolor:[UIColor textColor9999] cornerRadius:12 title:nil titleFont:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999]];
        [button setTitle:infoDic[@"name"] forState:UIControlStateNormal];
        
        [button setTitleColor:[UIColor mainThemeColor] forState:UIControlStateSelected];

        CGSize size = [infoDic[@"name"] sizeWithFont:[UIFont qg_lightFontOfSize:12] maxSize:CGSizeMake(200, 24)];
        
        button.frame = CGRectMake(0, 0, size.width+28, 24);
        [self.buttonsArray addObject:button];
        
    }
    
}


-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 4;
}

-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    __weak typeof(self)weakSelf = self;
    if (indexPath.row == 0) {
        //问题标签
        QGFeedbackQuestionTypeCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([QGFeedbackQuestionTypeCell class])];
        if (!cell) {
            cell = [[QGFeedbackQuestionTypeCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([QGFeedbackQuestionTypeCell class]) clickBlock:^(NSUInteger index) {
                NSLog(@"点击按钮 %lu",(unsigned long)index);
                weakSelf.questionInfo = weakSelf.btnInfoArray[index];
                [weakSelf.view endEditing:YES];
                if (![NSString isEmpty:weakSelf.feedbackStr]) {
                    [weakSelf.submitCell.loginButton setGradientButtonIsClickEnabled:YES];
                }else{
                    [weakSelf.submitCell.loginButton setGradientButtonIsClickEnabled:NO];
                }
            }];
        }
        
        cell.buttonList = self.buttonsArray;
        self.cellHeight = cell.cellHeight;
        return cell;
    }else if(indexPath.row == 1){
        //意见反馈输入框
        QGFeedbackTextViewCell *cell = (QGFeedbackTextViewCell *)[self getCellFromClassName:NSStringFromClass([QGFeedbackTextViewCell class]) dequeueTableView:tableView];
        
        cell.cellBlock = ^(NSString *feedbackStr) {
            weakSelf.feedbackStr = feedbackStr;
            if (![NSString isEmpty:weakSelf.feedbackStr] && weakSelf.questionInfo) {
                [weakSelf.submitCell.loginButton setGradientButtonIsClickEnabled:YES];
            }else{
                [weakSelf.submitCell.loginButton setGradientButtonIsClickEnabled:NO];
            }
        };
        return cell;
    }else if(indexPath.row == 2){
        //添加图片
        QGFeedbackAddImageTableViewCell *cell = (QGFeedbackAddImageTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGFeedbackAddImageTableViewCell class]) dequeueTableView:tableView];
        cell.cellBlock = ^(NSString *imageUrlStr) {
            weakSelf.imageURLStr = imageUrlStr;
        };
        return cell;
    }else{
        
        
        
        QGFeedbackSubmitBtnTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([QGFeedbackSubmitBtnTableViewCell class])];
        if (!cell) {
            //提交按钮
            cell = [[QGFeedbackSubmitBtnTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([QGFeedbackSubmitBtnTableViewCell class]) btnTitle:@"提交" padding:20];
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
        }

        self.submitCell = cell;
        cell.cellBlock = ^(UIButton *nextBtn) {
            //登录按钮点击事件
            [weakSelf.view endEditing:YES];
            
            [weakSelf submitFeedback];
            
        };
        
        return cell;
    }
}

-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{

    if (indexPath.row == 0) {
        return self.cellHeight;
    } else if(indexPath.row == 1){
        return 180;
    }else if(indexPath.row == 2){
        return 109;
    }else{
        return 185;
    }
    

    
}

-(NSMutableArray *)buttonsArray
{
    if (!_buttonsArray) {
        _buttonsArray = [[NSMutableArray alloc]init];
        
    }
    return _buttonsArray;
}

@end
