//
//  QGFeedbackQuestionTypeCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/28.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGFeedbackQuestionTypeCell.h"
#import "QGBasicUITool.h"
#import "QGHorizontalFlowButtonView.h"

@interface QGFeedbackQuestionTypeCell ()
///标题
@property (nonatomic, strong)UILabel *titleLabel;
///标签流式布局控件
@property (nonatomic, strong)QGHorizontalFlowButtonView * flowButtonView;

@end

@implementation QGFeedbackQuestionTypeCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier clickBlock:(QuestionSelect)questionBlock
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        _questionBlock = questionBlock;
        
        
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"请选择你要反馈的问题类型" titleFontSize:[UIFont qg_lightFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(20);
            make.top.equalTo(self.contentView).inset(20);
            make.height.mas_equalTo(25);
        }];
    
        self.cellHeight = 70;
        self.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    return self;
}

- (void)setButtonList:(NSMutableArray *)buttonList
{
    if (_buttonList != buttonList) {
        
        if (self.flowButtonView) {
            [self.flowButtonView removeFromSuperview];
        }
        
        self.flowButtonView = [[QGHorizontalFlowButtonView alloc] initWithFrame:CGRectMake(0, 70,MAINSCREEN_WIDTH , 0) buttonList:buttonList itemMargin:10 topMargin:0 leftMargin:20];
        @weakify(self);
        self.flowButtonView.selectBlock = ^(NSUInteger index) {
            @strongify(self);
            if (self.questionBlock) {
                self.questionBlock(index);
            }
        };
        [self.contentView addSubview:self.flowButtonView];
        
        self.cellHeight = 70 + 35 + self.flowButtonView.frame.size.height;
    }
}


@end
