//
//  QGFeedbackAddImageTableViewCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/7/1.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGFeedbackAddImageTableViewCell.h"
#import "QGSelectImageView.h"
#import "QGBasicUITool.h"
#import "QGImageModel.h"
@interface QGFeedbackAddImageTableViewCell ()
///标题
@property (nonatomic, strong)UILabel *titleLabel;
///添加图片
@property (nonatomic, strong)QGSelectImageView *addImageView;
@end

@implementation QGFeedbackAddImageTableViewCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"请提供相关问题截图或照片" titleFontSize:[UIFont qg_lightFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        
        self.addImageView = [[QGSelectImageView alloc] initWithFrame:CGRectMake(0, 35, MAINSCREEN_WIDTH, 74)];
        
        @weakify(self);
        self.addImageView.callBackBlock = ^(NSArray *addImageArray) {
            @strongify(self);
            //丢弃数组中的最后一个元素（因为最后一个为添加图片模型）
            NSMutableArray *array = [[NSMutableArray alloc] initWithCapacity:3];
            for (int i = 0; i<addImageArray.count-1; i++) {
                QGImageModel *imageModel = addImageArray[i];
                [array addObject:imageModel.completeUrl];
            }
            
            
            if (self.cellBlock) {
                self.cellBlock([array componentsJoinedByString:@","]);
            }
            
        };
        
        [self.contentView addSubview:self.addImageView];
        
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(20);
            make.top.equalTo(self.contentView).inset(0);
            make.height.mas_equalTo(25);
        }];
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    return self;
}

@end
