//
//  QGImageCollectionViewCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/26.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGImageCollectionViewCell.h"
#import "QGBasicUITool.h"

@implementation QGImageCollectionViewCell

-(instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        [self.contentView addSubview:self.iconImageView];
        [self.contentView addSubview:self.deleteBtn];
        
        self.iconImageView.frame = self.contentView.bounds;
    
        [self.deleteBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.right.equalTo(self.contentView);
            make.width.height.mas_equalTo(12);
        }];
    }
    
    return self;
}

-(UIImageView *)iconImageView
{
    if (!_iconImageView) {
        _iconImageView = [[UIImageView alloc]init];
        _iconImageView.contentMode = UIViewContentModeScaleAspectFill;
        _iconImageView.clipsToBounds = YES;
    }
    return _iconImageView;
}

-(UIButton *)deleteBtn
{
    if (!_deleteBtn) {
        _deleteBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_deleteBtn setBackgroundImage:[UIImage imageNamed:@"PostSaleDeletePhoto"] forState:UIControlStateNormal];
    }
    return _deleteBtn;
}

@end
