//
//  QGTextView.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/28.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGTextView.h"
#import "QGBasicUITool.h"


@implementation QGTextView

- (id) initWithFrame:(CGRect)frame {
    if ((self = [super initWithFrame:frame])) {
        [self initView];
    }
    return self;
}


- (void)initView {
    //监听TextView编辑的通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(DidChange:) name:UITextViewTextDidChangeNotification object:self];
    //监听TextView开始编辑的通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(textBeginEditing) name:UITextViewTextDidBeginEditingNotification object:self];
    //监听TextView结束编辑的通知
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(didEndEditing) name:UITextViewTextDidEndEditingNotification object:self];

    //默认的边距
    float left=13,top=9;
    //设置默认属性
    self.placeholderColor = [UIColor textColor9999];
    self.placeholderFont = [UIFont qg_regularFontOfSize:14];
    self.placeholderLabel=[[UILabel alloc] initWithFrame:CGRectMake(left, top,CGRectGetWidth(self.frame)-2*left,20)];
    self.placeholderLabel.numberOfLines = 0;
    self.placeholderLabel.textColor = self.placeholderColor;
    self.placeholderLabel.font = self.placeholderFont;
    self.placeholderLabel.text=self.placeholder;
    [self addSubview:self.placeholderLabel];

}

-(void)setPlaceholder:(NSString *)placeholder{
    _placeholder=placeholder;

    if (_placeholder.length == 0 || [_placeholder isEqualToString:@""]) {
        self.placeholderLabel.hidden=YES;
    }else{
        self.placeholderLabel.hidden=NO;
        self.placeholderLabel.text=_placeholder;
    }
}

-(void)setPlaceholderFont:(UIFont *)placeholderFont
{
    _placeholderFont = placeholderFont;
    self.placeholderLabel.font = _placeholderFont;
}

-(void)setPlaceholderColor:(UIColor *)placeholderColor
{
    _placeholderColor = placeholderColor;
    self.placeholderLabel.textColor = placeholderColor;
}

//正在编辑控制提示文字是否显示
-(void)DidChange:(NSNotification*)noti{
    
    if (self.placeholder.length == 0 || [self.placeholder isEqualToString:@""]) {
        self.placeholderLabel.hidden=YES;
    }
    
    if (self.text.length > 0) {
        self.placeholderLabel.hidden=YES;
    }
    else{
        self.placeholderLabel.hidden=NO;
    }
    
    
}

//开始编辑，显示边框
-(void)textBeginEditing
{
    if (self.isShowBorder) {
        self.layer.borderWidth = 1;
        self.layer.borderColor = [UIColor colorWithHexString:@"EBB45F"].CGColor;
    }
}
//结束编辑取消边框
-(void)didEndEditing
{
    if (self.isShowBorder) {
        self.layer.borderWidth = 0;
        self.layer.borderColor = [UIColor clearColor].CGColor;
    }
}

-(void)dealloc{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [self.placeholderLabel removeFromSuperview];
    
}

@end
