//
//  QGQuotaManagerHeaderCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/24.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGQuotaManagerHeaderCell.h"
#import "QGBasicUITool.h"

#import "ZHAttributedLabelTool.h"
#import "QGAlertView.h"
@interface QGQuotaManagerHeaderCell ()

/// 授信总额度标题
@property (nonatomic, strong) UILabel * totalAmountTitleLabel;

/// 总额度
@property (nonatomic, strong) UILabel * totalAmountLabel;

/// 可用额度标题
@property (nonatomic, strong) UIButton * canUseAmountTitleButton;

/// 可用额度
@property (nonatomic, strong) UILabel * canUseAmountLabel;

/// 已用额度标题
@property (nonatomic, strong) UILabel * usedAmountTitleLabel;

/// 已用额度
@property (nonatomic, strong) UILabel * usedAmountLabel;

/// 待激活额度标题
@property (nonatomic, strong) UIButton * waitingActivationTitleButton;

/// 待激活额度
@property (nonatomic, strong) UILabel * waitingActivationLabel;

/// 零钱标题
@property (nonatomic, strong) UILabel * pocketAmountTitleLabel;

/// 零钱额度
@property (nonatomic, strong) UILabel * pocketAmountLabel;

/// 开通享花卡
@property (nonatomic, strong, readwrite) QGGradientShadowButton * openButton;

/// 提额按钮
@property (nonatomic, strong, readwrite) QGGradientShadowButton * increaseButton;
@end

@implementation QGQuotaManagerHeaderCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        //总额度标题
        self.totalAmountTitleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_mediumFontOfSize:12] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.totalAmountTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(20);
            make.top.offset(10);
            make.height.mas_equalTo(17);
        }];
        
        /// 总额度
        self.totalAmountLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"--" titleFontSize:[UIFont qg_numberFontOfSize:35] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.totalAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(20);
            make.top.mas_equalTo(self.totalAmountTitleLabel.mas_bottom).offset(6);
            make.height.mas_equalTo(35);
        }];
        
        //开通按钮
        self.openButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:@"开通享花卡，立获额度" textFont:[UIFont qg_regularFontOfSize:14]];
        self.openButton.hidden = YES;
        [self.openButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.right.inset(20);
            make.size.mas_equalTo(CGSizeMake(170, 33));
        }];
        
        //开通按钮
        self.increaseButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:@"提额" textFont:[UIFont qg_regularFontOfSize:14]];
        self.increaseButton.hidden = YES;
        [self.increaseButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.right.inset(20);
            make.size.mas_equalTo(CGSizeMake(96, 33));
        }];
        
        
        //三等分宽度
        CGFloat labelWidth = (MAINSCREEN_WIDTH - 20 * 2)/3.0;
        
        //可用额度标题
        self.canUseAmountTitleButton = [UIButton creatButtonWithSuperView:self.contentView title:nil titleFont:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999]];
        self.canUseAmountTitleButton.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
        
        [self.canUseAmountTitleButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.offset(20);
            make.top.mas_equalTo(self.totalAmountLabel.mas_bottom).offset(25);
            make.size.mas_equalTo(CGSizeMake(labelWidth, 17));
        }];
        [self.canUseAmountTitleButton addTarget:self action:@selector(canUseAmountButtonClick) forControlEvents:UIControlEventTouchUpInside];
        
        //可用额度
        self.canUseAmountLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"--" titleFontSize:[UIFont qg_numberFontOfSize:20] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.canUseAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.height.mas_equalTo(self.canUseAmountTitleButton);
            make.top.mas_equalTo(self.canUseAmountTitleButton.mas_bottom).offset(11);
        }];
        
        //已用额度
        self.usedAmountTitleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:self.canUseAmountTitleButton.titleLabel.font textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.usedAmountTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.canUseAmountTitleButton.mas_right);
            make.top.width.height.mas_equalTo(self.canUseAmountTitleButton);
        }];

        /// 已用额度
        self.usedAmountLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"--" titleFontSize:self.canUseAmountLabel.font textColor:self.canUseAmountLabel.textColor alignment:NSTextAlignmentLeft];
        [self.usedAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.mas_equalTo(self.usedAmountTitleLabel);
            make.top.bottom.mas_equalTo(self.canUseAmountLabel);
        }];
        
        //待激活标题
        self.waitingActivationTitleButton = [UIButton creatButtonWithSuperView:self.contentView title:nil titleFont:self.canUseAmountTitleButton.titleLabel.font textColor:self.canUseAmountTitleButton.titleLabel.textColor];
        self.waitingActivationTitleButton.contentHorizontalAlignment = UIControlContentHorizontalAlignmentLeft;
        [self.waitingActivationTitleButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.usedAmountTitleLabel.mas_right);
            make.top.width.height.mas_equalTo(self.usedAmountTitleLabel);
        }];
        
        [self.waitingActivationTitleButton addTarget:self action:@selector(waitingActivationButtonClick) forControlEvents:UIControlEventTouchUpInside];
        
        /// 待激活额度
       self.waitingActivationLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"--" titleFontSize:self.usedAmountLabel.font textColor:self.usedAmountLabel.textColor alignment:NSTextAlignmentLeft];
        [self.waitingActivationLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.waitingActivationTitleButton);
            make.top.width.height.mas_equalTo(self.usedAmountLabel);
        }];
        
        //零钱可用额度
        UIView * pocketBgView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor moduleSeparatorColorF7F7]];
        pocketBgView.layer.cornerRadius = 2;
        pocketBgView.clipsToBounds = YES;
        [pocketBgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.canUseAmountLabel);
            make.top.mas_equalTo(self.canUseAmountLabel.mas_bottom).offset(11);
            make.height.mas_equalTo(60);
        }];
        
        //零钱描述提示
        UIButton * pocketButton = [UIButton creatButtonWithSuperView:pocketBgView title:nil titleFont:nil textColor:nil];
        [pocketButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.offset(0);
        }];
        [pocketButton addTarget:self action:@selector(pocketDescButtonClick) forControlEvents:UIControlEventTouchUpInside];
        
        //箭头指示
        UIImageView * pocketArrowImg = [UIImageView creatImageViewWithSuperView:self.contentView imageName:@"quota_pocket_arrow"];
        [pocketArrowImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(12, 5));
            make.bottom.mas_equalTo(pocketBgView.mas_top);
            make.centerX.mas_equalTo(pocketBgView);
        }];
        
        //右侧提示图片
        UIImageView * pocketImgView = [UIImageView creatImageViewWithSuperView:pocketBgView imageName:@"quota_manager_info"];
        [pocketImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.right.inset(5);
            make.size.mas_equalTo(CGSizeMake(12, 12));
        }];
        
        //零钱可用标题
        self.pocketAmountTitleLabel = [UILabel creatLabelWithSuperView:pocketBgView title:nil titleFontSize:[UIFont qg_lightFontOfSize:10] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.pocketAmountTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(10);
            make.right.inset(20);
            make.top.inset(11);
            make.height.mas_equalTo(14);
        }];
        
        //零钱可用额度
        self.pocketAmountLabel = [UILabel creatLabelWithSuperView:pocketBgView title:nil titleFontSize:[UIFont qg_numberFontOfSize:16] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.pocketAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(10);
            make.right.inset(20);
            make.height.mas_equalTo(16);
            make.top.mas_equalTo(self.pocketAmountTitleLabel.mas_bottom).offset(6);
        }];
        
        
    }
    return self;
}


- (void)setDataModel:(QGQuotaManagerModel *)dataModel
{
    if (_dataModel != dataModel) {
        _dataModel = dataModel;
        
        //设置金额
        self.totalAmountLabel.text = [self getStringWithAmount:_dataModel.userQuotaInfo.creditTotalAmount];
        self.canUseAmountLabel.text = [self getStringWithAmount:_dataModel.userQuotaInfo.canUseAmount];
        self.usedAmountLabel.text = [self getStringWithAmount:_dataModel.userQuotaInfo.usedAmount];
        self.waitingActivationLabel.text = [self getStringWithAmount:_dataModel.userQuotaInfo.waitingActivationAmount];
        self.pocketAmountLabel.text = [self getStringWithAmount:_dataModel.userQuotaInfo.pocketAmount];
        
        self.openButton.hidden = _dataModel.hasReceivedQuota.boolValue ? YES : NO;
        
        //优先判断是否允许展示
        if (_dataModel.showIncrementQuotaBtn.boolValue) {
            self.increaseButton.hidden = !self.openButton.isHidden;
        }
        

        //是否展示待激活额度
        //控制待激活额度的显示和隐藏逻辑
        self.waitingActivationTitleButton.hidden = !_dataModel.userQuotaInfo.showWaitingActivityQuota.boolValue;
        self.waitingActivationLabel.hidden = !_dataModel.userQuotaInfo.showWaitingActivityQuota.boolValue;
        
        
        //设置标题
        self.totalAmountTitleLabel.text = _dataModel.userQuotaInfo.creditTotalAmountTitle;
        self.usedAmountTitleLabel.text = _dataModel.userQuotaInfo.usedAmountTitle;
        self.pocketAmountTitleLabel.text = _dataModel.userQuotaInfo.pocketAmountTitle;
        //可用额度富文本
        ZHAttributedLabelTool * canUseAmountTool = [[ZHAttributedLabelTool alloc] initWithText:_dataModel.userQuotaInfo.canUseAmountTitle font:[UIFont qg_lightFontOfSize:12] color:[UIColor textColor9999]];
        [canUseAmountTool addAttachmentWithImageName:@"quota_manager_info" index:_dataModel.userQuotaInfo.canUseAmountTitle.length size:CGRectMake(2, -2.5, 12, 12)];
        [self.canUseAmountTitleButton setAttributedTitle:[canUseAmountTool getResultString] forState:UIControlStateNormal];
        //待激活额度富文本
        ZHAttributedLabelTool * waitingActivationTool = [[ZHAttributedLabelTool alloc] initWithText:_dataModel.userQuotaInfo.waitingActivationAmountTitle font:[UIFont qg_lightFontOfSize:12] color:[UIColor textColor9999]];
        [waitingActivationTool addAttachmentWithImageName:@"quota_manager_info" index:_dataModel.userQuotaInfo.waitingActivationAmountTitle.length size:CGRectMake(2, -2.5, 12, 12)];
        [self.waitingActivationTitleButton setAttributedTitle:[waitingActivationTool getResultString] forState:UIControlStateNormal];
    }
}


- (NSString *)getStringWithAmount:(NSString *)amount
{
    if (![NSString isEmpty:amount] && self.dataModel.hasReceivedQuota.boolValue) {
       return [NSString stringWithFormat:@"%.2f",amount.floatValue];
    }
    return @"--";
}

#pragma mark -  Action
///可用额度弹窗提示
- (void)canUseAmountButtonClick
{
    if (![NSString isEmpty:self.dataModel.userQuotaInfo.canUseAmountDesc] && [QGUserInfo isLogin]) {
        QGAlertView * alert = [[QGAlertView alloc] initWithTitle:self.dataModel.userQuotaInfo.canUseAmountTitle message:self.dataModel.userQuotaInfo.canUseAmountDesc cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:nil];
        [alert showInView:nil];
    }
}

/// 待激活额度
- (void)waitingActivationButtonClick
{
    if (![NSString isEmpty:self.dataModel.userQuotaInfo.waitingActivationAmountDesc] && [QGUserInfo isLogin]) {
        QGAlertView * alert = [[QGAlertView alloc] initWithTitle:self.dataModel.userQuotaInfo.waitingActivationAmountTitle message:self.dataModel.userQuotaInfo.waitingActivationAmountDesc cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:nil];
        [alert showInView:nil];
    }
}

/// 零钱提示
- (void)pocketDescButtonClick
{
    if (![NSString isEmpty:self.dataModel.userQuotaInfo.pocketAmountDesc] && [QGUserInfo isLogin]) {
            QGAlertView * alert = [[QGAlertView alloc] initWithTitle:self.dataModel.userQuotaInfo.pocketAmountTitle message:self.dataModel.userQuotaInfo.pocketAmountDesc cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:nil];
            [alert showInView:nil];
    }
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
