//
//  QGQuotaAdvantageCell.m
//  VirtualPayment
//
//  Created by 张博 on 2019/9/25.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGQuotaAdvantageCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGQuotaAdvantageCell ()

/// 颜色背景
@property (nonatomic, strong) UIView * colorBgView;

/// icon
@property (nonatomic, strong) UIImageView * iconImageView;

/// 标题
@property (nonatomic, strong) UILabel * titleLabel;

/// 详情
@property (nonatomic, strong) UILabel * descLabel;
@end

@implementation QGQuotaAdvantageCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        //背景
        self.colorBgView = [UIView creatViewWithSuperView:self.contentView backgroundColor:nil];
        [self.colorBgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.top.bottom.inset(10);
        }];
        self.colorBgView.layer.cornerRadius = 5;
        self.colorBgView.clipsToBounds = YES;
        
        //icon
        self.iconImageView = [UIImageView creatImageViewWithSuperView:self.colorBgView imageName:nil];
        self.iconImageView.clipsToBounds = YES;
        [self.iconImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(50, 50));
            make.left.offset(10);
            make.centerY.offset(0);
        }];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.colorBgView title:nil titleFontSize:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.iconImageView.mas_right).offset(9);
            make.top.offset(7);
            make.height.mas_equalTo(20);
            make.right.inset(10);
        }];
        
        //描述
        self.descLabel = [UILabel creatLabelWithSuperView:self.colorBgView title:nil titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        self.descLabel.numberOfLines = 2;
        [self.descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.titleLabel);
            make.top.mas_equalTo(self.titleLabel.mas_bottom).offset(3);
            make.right.inset(20);
        }];
        
    }
    return self;
}


- (void)setListModel:(QGAdvantageInfoListModel *)listModel
{
    if (_listModel != listModel) {
        _listModel = listModel;
        
        [self.iconImageView setImageByNomalPlaceholderWithURLString:_listModel.imageUrl];
        self.titleLabel.text = _listModel.advantageName;
        self.descLabel.text = _listModel.advantageDesc;
        self.colorBgView.backgroundColor = [UIColor colorWithHexString:_listModel.backgroundColor];
    }
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
