//
//  QGIncreaseStrategyCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/1/17.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGIncreaseStrategyCell.h"
#import "QGBasicUITool.h"
#import "UIView+Layer.h"

@interface QGIncreaseStrategyCell ()

///去看看
@property (nonatomic, strong, readwrite) QGGradientShadowButton * openButton;
@end


@implementation QGIncreaseStrategyCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        //背景视图
        UIView * shadowView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor whiteColor]];
        [shadowView setShadowColor:[UIColor shadowColor] shadowRadius:3 shadowOffset:CGSizeMake(0, 1) cornerRadius:6];
        [shadowView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(20);
            make.height.mas_equalTo(40);
            make.top.inset(3);
        }];
        
        //图片
        UIImageView * iconImgView = [UIImageView creatImageViewWithSuperView:shadowView imageName:@"quota_increase_strategy"];
        [iconImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(10);
            make.size.mas_equalTo(CGSizeMake(28, 28));
            make.centerY.offset(0);
        }];
        
        //标题
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:shadowView title:@"享花卡提额攻略" titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(iconImgView.mas_right).offset(7);
            make.centerY.offset(0);
        }];
        
        
        //去看看按钮
        self.openButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:shadowView title:@"去看看" textFont:[UIFont qg_lightFontOfSize:12]];
        [self.openButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(68, 24));
            make.right.inset(10);
            make.centerY.offset(0);
        }];
                
    }
    return self;
}


@end
