//
//  QGMallRequestApi.h
//  VirtualPayment
//
//  Created by 张博 on 2020/2/24.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, QGMallRequestServerMethod) {
    ///省钱首页
    QGMallRequestServerMethodHomepage,
    ///商城首页菜单栏
    QGMallRequestServerMethodMallMenu,
    ///商品详情页
    QGMallRequestServerMethodGoodsDetail,
    ///获取去购买商品链接
    QGMallRequestServerMethodMallShopUrl,
    ///搜索接口
    QGMallRequestServerMethodSearch,
    ///大家都在搜
    QGMallRequestServerMethodHotSearches,
    /// 绑定授权
    QGMallRequestServerMethodBindAuthUser,
    /// 今日热销
    QGMallRequestServerMethodBestSeller,
    ///分享页面数据
    QGMallRequestServerMethodShare,
    ///猜你喜欢
    QGMallRequestServerMethodRecently,
    /// 获取授权结果
    QGMallRequestServerMethodAuthResult,
    /// 获取淘宝授权基础配置-taobaoAuthUrl
    QGMallRequestServerMethodBaseConfig,
    /// 解除授权
    QGMallRequestServerMethodUnBindTaoBaoAuth
    
};


@interface QGMallRequestApi : NSObject

/*
 接口URL
 */
+ (NSString *)urlWithIndex:(QGMallRequestServerMethod)index;

@end

NS_ASSUME_NONNULL_END
