//
//  QGMallSearchSectionView.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/25.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallSearchSectionView.h"
#import "QGBasicUITool.h"


#pragma mark - QGMallSearchSectionItem 内部的Model

@implementation QGMallSearchSectionItem

@end



#pragma mark - QGMallSearchSectionItemView 小视图控件

@interface QGMallSearchSectionItemView ()
/// 标题
@property (nonatomic, strong) UILabel *titleLab ;
/// 排序图标
@property (nonatomic, strong) UIImageView *sortImageView;
/// 点击按钮
@property (nonatomic, strong) UIButton *touchBtn;

@property (nonatomic, strong) QGMallSearchSectionItem *item ;

@end

@implementation QGMallSearchSectionItemView

- (instancetype)initWithModel:(QGMallSearchSectionItem *)item
{
    self = [super init];
    if (self) {
        self.item = item;
        /// 标题
        self.titleLab = [UIView creatLabelWithSuperView:self title:item.title titleFontSize:[UIFont qg_regularFontOfSize:14.0f] textColor:UIColor.textColor6666 alignment:NSTextAlignmentCenter];
        [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.centerY.equalTo(self);
        }];
        /// 排序图标
        self.sortImageView = [UIView creatImageViewWithSuperView:self imageName:@"mall_sort_no"];
        [self.sortImageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.titleLab.mas_right).offset(4);
            make.height.mas_equalTo(8);
            make.width.mas_equalTo(5);
            make.centerY.equalTo(self.titleLab);
        }];
        
        self.sortImageView.hidden = !item.sortAble;
        /// 覆盖视图的点击Button
        self.touchBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self addSubview:_touchBtn];
        
        [self.touchBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self);
        }];
        
        [_touchBtn addTarget:self action:@selector(touchAction:) forControlEvents:UIControlEventTouchUpInside];
        
    }
    return self;
}

- (void)setSelect:(BOOL)select
{
    if (_select != select) {
        _select = select;
    }
    /// 选中状态-排序发生变化
    if (select) {
        self.titleLab.font = [UIFont qg_mediumFontOfSize:14.0f];
        self.titleLab.textColor = UIColor.textColor3333;
        if (self.sortType == QGMallSearchSectionSortTypeNone) {
            self.sortType = self.item.downToUp?QGMallSearchSectionSortTypeDescending:QGMallSearchSectionSortTypeAscending;
        }else if (self.sortType == QGMallSearchSectionSortTypeDescending){
            self.sortType = QGMallSearchSectionSortTypeAscending;
        }else {
            self.sortType = QGMallSearchSectionSortTypeDescending;
        }
    }else{
        /// 非选中状态-排序置为None
        self.titleLab.font = [UIFont qg_regularFontOfSize:14.0f];
        self.titleLab.textColor = UIColor.textColor6666;
        self.sortType = QGMallSearchSectionSortTypeNone;
    }
}

- (void)setSortType:(QGMallSearchSectionSortType)sortType
{
    if (_sortType != sortType) {
        _sortType = sortType;
        
        if (sortType == QGMallSearchSectionSortTypeNone) {
            self.sortImageView.image = [UIImage imageNamed:@"mall_sort_no"];
        }else if (sortType == QGMallSearchSectionSortTypeAscending){
            self.sortImageView.image = [UIImage imageNamed:@"mall_sort_ascending"];
        }else{
            self.sortImageView.image = [UIImage imageNamed:@"mall_sort_descending"];
        }
    }
}

- (void)touchAction:(UIButton *)btn
{
    /// 设置当前选中效果
    self.select = YES;
    if (self.touchBlock) {
        self.touchBlock(self);
    }
}

@end


#pragma mark - QGMallSearchSectionView 整个SectionView区域视图

@interface QGMallSearchSectionView ()

/// 上次选中的ItemView,用于重置状态
@property (nonatomic, strong)QGMallSearchSectionItemView *lastSelectItemView;

@property (nonatomic, strong)UIButton *layoutBtn;

/// items背景视图
@property (nonatomic, strong) UIView *itemsBackView ;

/// 优惠券开关视图
@property (nonatomic, strong) UIView *couponBackView ;

/// 优惠券开关
@property (nonatomic, strong) UISwitch *couponSwitch ;

@end

@implementation QGMallSearchSectionView

- (id)init
{
    self = [super init];
    if (self) {
        self.backgroundColor = [UIColor whiteColor];
    }
    return self;
}

- (id)initWithItems:(NSArray <QGMallSearchSectionItem *>*)items
{
    self = [super init];
    if (self) {
        self.items = items;
    }
    return self;
}

- (id)initWithItems:(NSArray <QGMallSearchSectionItem *>*)items layoutEnable:(BOOL)enable
{
    self  = [super init];
    if (self) {
        self.layoutEnable = enable;
        self.items = items;
    }
    return self;
}

#pragma mark - 点击方式

/// 设置组件
- (void)setupsWithItems:(NSArray <QGMallSearchSectionItem *>*)items
{
    [self.subviews enumerateObjectsWithOptions:NSEnumerationReverse usingBlock:^(__kindof UIView * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
               [obj removeFromSuperview];
    }];
    /// 空视图
    if(items.count == 0) return;
    
    self.itemsBackView = [UIView creatViewWithSuperView:self backgroundColor:UIColor.whiteColor];
    
    [self.itemsBackView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.equalTo(self);
        make.height.mas_equalTo(45);
        make.bottom.lessThanOrEqualTo(self);
    }];
    
    /// 左边的ItemView
    QGMallSearchSectionItemView *leftItemView = nil;
    
    @weakify(self);
    for (int i = 0; i < items.count; i++) {
        QGMallSearchSectionItem *model = items[i];
        QGMallSearchSectionItemView *itemView = [[QGMallSearchSectionItemView alloc]initWithModel:model];
        /// 默认选中第一个
        if (i==0) {
            itemView.select = YES;
            self.lastSelectItemView = itemView;
        }
        itemView.tag = 1000 + i;
        [self.itemsBackView addSubview:itemView];
        /// 组件的点击事件
        itemView.touchBlock = ^(QGMallSearchSectionItemView * _Nonnull item) {
            @strongify(self);
            [self selectItemAction:item];
        };
        /// 等分约束视图
        if (leftItemView) {
            [itemView mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.equalTo(leftItemView.mas_right);
                make.centerY.equalTo(leftItemView);
                make.width.height.equalTo(leftItemView);
            }];
        }else{
            [itemView mas_makeConstraints:^(MASConstraintMaker *make) {
                make.left.inset(0);
//                make.centerY.equalTo(self.itemsBackView);
                make.top.bottom.equalTo(self.itemsBackView);
            }];
        }
        leftItemView = itemView;
    }
    
    if (self.layoutEnable) {
        [self.itemsBackView addSubview:self.layoutBtn];
        [self.layoutBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(0);
            make.top.bottom.equalTo(self.itemsBackView);
            make.width.equalTo(leftItemView).multipliedBy(0.8);
        }];
        /// 最后加上右边约束
        [leftItemView mas_updateConstraints:^(MASConstraintMaker *make) {
            make.right.equalTo(self.layoutBtn.mas_left);
        }];
    }else{
        /// 最后加上右边约束
        [leftItemView mas_updateConstraints:^(MASConstraintMaker *make) {
            make.right.inset(0);
        }];
    }
    
    if (self.hasCouponSwitch) {
        self.couponBackView = [UIView creatViewWithSuperView:self backgroundColor:UIColor.whiteColor];
        [self.couponBackView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.itemsBackView.mas_bottom);
            make.left.right.bottom.equalTo(self);
            make.height.mas_equalTo(30);
        }];
        
        UIImageView *couponImageV = [UIImageView creatImageViewWithSuperView:self.couponBackView imageName:@"list_coupon"];
        [couponImageV mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(20);
            make.centerY.equalTo(self.couponBackView);
        }];
        
        UILabel *textLab = [UILabel creatLabelWithSuperView:self.couponBackView title:@"仅显示优惠券商品" titleFontSize:[UIFont qg_regularFontOfSize:12.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentLeft];
        [textLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(couponImageV.mas_right).offset(2);
            make.centerY.equalTo(couponImageV);
        }];
        
        self.couponSwitch = [[UISwitch alloc]initWithFrame:CGRectZero];
        [self.couponBackView addSubview:_couponSwitch];
        _couponSwitch.onTintColor = [UIColor colorWithHexString:@"#FF5A4B"];
        _couponSwitch.transform = CGAffineTransformMakeScale(0.72, 0.72);
        [_couponSwitch addTarget:self action:@selector(swicthAction:) forControlEvents:UIControlEventValueChanged];
        [self.couponSwitch mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(18);
            make.centerY.equalTo(self.couponBackView);
        }];
        
    }else{
        if (self.couponBackView) {
            [self.couponBackView removeFromSuperview];
        }
    }
}

- (void)swicthAction:(UISwitch *)aSwitch
{
    if (self.switchBlock) {
        self.switchBlock(aSwitch.on);
    }
}

- (void)setItems:(NSArray<QGMallSearchSectionItem *> *)items
{
    _items = items;
    [self setupsWithItems:items];
}

- (void)setLayoutEnable:(BOOL)layoutEnable
{
    if (_layoutEnable != layoutEnable) {
        _layoutEnable = layoutEnable;
        [self setupsWithItems:self.items];
    }
}

- (void)setHasCouponSwitch:(BOOL)hasCouponSwitch
{
    if (_hasCouponSwitch != hasCouponSwitch) {
        _hasCouponSwitch = hasCouponSwitch;
        [self setupsWithItems:self.items];
    }
}

/// 点击每个Item的事件
/// @param item 当前点击item
- (void)selectItemAction:(QGMallSearchSectionItemView *)item
{
    /// 如果选中的不是同一个,上一个select置为No
    if (item != self.lastSelectItemView) {
        self.lastSelectItemView.select = NO;
        self.lastSelectItemView = item;
    }
    if (self.touchItemBlock) {
        self.touchItemBlock(item.tag - 1000,item.sortType);
    }
}

/// 点击排布改变cell的布局方式
/// @param btn UIButton
- (void)cellLayout:(UIButton *)btn
{
    self.isBox = !self.isBox;
    if (self.cellLayoutBlock) {
        self.cellLayoutBlock(self.isBox);
    }
}

#pragma mark - 懒加载

- (UIButton *)layoutBtn
{
    if (_layoutBtn == nil) {
        _layoutBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_layoutBtn setImage:[UIImage imageNamed:@"mall_layout_nomal"] forState:UIControlStateNormal];
        [_layoutBtn addTarget:self action:@selector(cellLayout:) forControlEvents:UIControlEventTouchUpInside];
    }
    return _layoutBtn;
}

- (void)setIsBox:(BOOL)isBox
{
    _isBox = isBox;
    NSString *imageName = isBox ? @"mall_layout_nomal":@"mall_layout_box";
    [self.layoutBtn setImage:[UIImage imageNamed:imageName] forState:UIControlStateNormal];
    
}



/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
