//
//  QGMallSearchBarView.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/25.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallSearchBarView.h"
#import "QGBasicUITool.h"
#import "QGAnalyticsService.h"


@interface QGMallSearchBarView ()<UITextFieldDelegate>

/// 椭圆的背景视图
@property (nonatomic, strong)UIView *backView;
/// 搜索小图标
@property (nonatomic, strong) UIImageView *searchIcon;
/// 搜索框
@property (nonatomic, strong) UITextField *searchTextField ;
/// 取消按钮
@property (nonatomic, strong) UIButton *cancleBtn ;

@end

@implementation QGMallSearchBarView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        
        self.cancleBtn = [UIButton creatButtonWithSuperView:self title:@"取消" titleFont:[UIFont qg_regularFontOfSize:16.0] textColor:UIColor.textColor3333];
        
        self.backView = [UIView creatViewWithSuperView:self backgroundColor:UIColor.moduleSeparatorColorF7F7];
        
        [self.cancleBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(4);
            make.centerY.equalTo(self.backView);
            make.width.mas_equalTo(36);
        }];
        
        self.backView.layer.cornerRadius = 15;
        self.backView.layer.borderWidth = 0.5;
        self.backView.layer.borderColor = UIColor.lineSeparatorColorDCDC.CGColor;
        self.backView.layer.masksToBounds = YES;
        [self.backView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(4);
            make.centerY.equalTo(self);
            make.height.mas_equalTo(30);
            make.right.equalTo(self.cancleBtn.mas_left).offset(-8);
        }];
        
        self.searchIcon = [UIImageView creatImageViewWithSuperView:self.backView imageName:@"mall_search_icon"];
        [self.searchIcon mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(8);
            make.width.mas_equalTo(12);
            make.height.mas_equalTo(13);
            make.centerY.equalTo(self.backView);
        }];
        
        self.searchTextField = [UITextField creatTextFieldWithSuperView:self.backView placeholder:@"搜索品牌/商品名称/粘贴宝贝标题" titleFontSize:[UIFont qg_regularFontOfSize:13.0f] textColor:UIColor.textColor3333 tintColor:UIColor.yyMainThemeColor clearButtonMode:UITextFieldViewModeNever];
        self.searchTextField.returnKeyType = UIReturnKeySearch;
        self.searchTextField.delegate = self;
        
        [self.searchTextField mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.searchIcon.mas_right).offset(4);
            make.top.bottom.equalTo(self.backView);
            make.right.equalTo(self.backView).offset(8);
        }];
        
       
        
        [self.cancleBtn addTarget:self action:@selector(cancleAction:) forControlEvents:UIControlEventTouchUpInside];
    }
    return self;
}

- (void)resignFirstResponder
{
    [self.searchTextField resignFirstResponder];
}

- (void)becomeFirstResponder
{
    [self.searchTextField becomeFirstResponder];
}

- (void)setSearchText:(NSString *)searchText
{
    if (_searchText != searchText) {
        _searchText = searchText;
    }
    self.searchTextField.text = searchText;
}

- (void)cancleAction:(UIButton *)btn
{
    if (self.cancleBlock) {
        self.cancleBlock();
    }
}

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
    return YES;
}

- (BOOL)textFieldShouldEndEditing:(UITextField *)textField
{
    
    return YES;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField
{
    /// 空的时候不可点击
    if (textField.text.length == 0) return NO;
    
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:@"搜索页" path:@"搜索栏" name:@"搜索栏" detail_name:nil  acmc_model_other:textField.text];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
    if (self.searchBlock) {
        self.searchBlock(textField.text);
    }
    /// 赋值当前的searchText,以防当前值不一样.
    _searchText = textField.text;
    return YES;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
