//
//  QGMallSearchBarCoverView.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallSearchBarCoverView.h"
#import "QGBasicUITool.h"

@interface QGMallSearchBarCoverView ()

/// 椭圆的背景视图
@property (nonatomic, strong)UIView *backView;
/// 搜索小图标
@property (nonatomic, strong) UIImageView *searchIcon;

/// 搜索文字背景-圆角-灰色
@property (nonatomic, strong) UIView *searchTextBackView ;
/// 当前搜索的文字
@property (nonatomic, strong) UILabel *searchTextLab;
/// 删除文字按钮
@property (nonatomic, strong) UIButton *searchDeleteBtn;

/// 取消按钮
@property (nonatomic, strong) UIButton *cancleBtn ;

@end

@implementation QGMallSearchBarCoverView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.cancleBtn = [UIButton creatButtonWithSuperView:self title:@"取消" titleFont:[UIFont qg_regularFontOfSize:16.0] textColor:UIColor.textColor3333];
        
        self.backView = [UIView creatViewWithSuperView:self backgroundColor:UIColor.moduleSeparatorColorF7F7];
        
        [self.cancleBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(4).priorityHigh();
            make.centerY.equalTo(self.backView);
            make.width.mas_equalTo(36);
        }];
        
        self.backView.layer.cornerRadius = 15;
        self.backView.layer.borderWidth = 0.5;
        self.backView.layer.borderColor = UIColor.lineSeparatorColorDCDC.CGColor;
        self.backView.layer.masksToBounds = YES;
        [self.backView mas_makeConstraints:^(MASConstraintMaker *make) {
            if (@available(iOS 11.0, *)){
                make.left.inset(0);
            }else{
                make.left.inset(-8);
            }
            
            make.centerY.equalTo(self);
            make.height.mas_equalTo(30);
            make.right.equalTo(self.cancleBtn.mas_left).offset(-8);
        }];
        
        self.searchIcon = [UIImageView creatImageViewWithSuperView:self.backView imageName:@"mall_search_icon"];
        [self.searchIcon mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(8);
            make.width.mas_equalTo(12);
            make.height.mas_equalTo(13);
            make.centerY.equalTo(self.backView);
        }];
        
        /// 点击输入框空白的按钮事件
        UIButton *searchTextBackBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self.backView addSubview:searchTextBackBtn];
        [searchTextBackBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.searchIcon.mas_right).offset(4);
            make.top.bottom.right.equalTo(self.backView);
        }];
        /// 点击输入框的交互事件-实际上输入框并不存在,只是一个背景
        [searchTextBackBtn addTarget:self action:@selector(coverTextFiledAction:) forControlEvents:UIControlEventTouchUpInside];
        
        self.searchTextBackView = [UIView creatViewWithSuperView:self.backView backgroundColor:UIColor.textColor9999];
        _searchTextBackView.layer.cornerRadius = 13;
        _searchTextBackView.clipsToBounds = YES;
        
        [self.searchTextBackView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.equalTo(self.searchIcon.mas_right).offset(4);
            make.top.bottom.equalTo(self.backView).inset(2);
            make.width.greaterThanOrEqualTo(@40);
            make.right.lessThanOrEqualTo(self.backView).inset(8);
        }];
        
        /// 点击内容的按钮
        UIButton *contentBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [self.searchTextBackView addSubview:contentBtn];
        [contentBtn addTarget:self action:@selector(coverTextFiledAction:) forControlEvents:UIControlEventTouchUpInside];
        [contentBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self.searchTextBackView);
        }];
        
        /// 当前搜索的文字
        self.searchTextLab = [UIView creatLabelWithSuperView:self.searchTextBackView title:@"搜索你想要的宝贝" titleFontSize:[UIFont qg_regularFontOfSize:13.0f] textColor:UIColor.whiteColor alignment:NSTextAlignmentLeft];
     
        /// 删除文字按钮
        self.searchDeleteBtn = [UIButton buttonWithType:UIButtonTypeCustom];
        [_searchDeleteBtn setImage:[UIImage imageNamed:@"mall_search_text_delete"] forState:UIControlStateNormal];
        _searchDeleteBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentRight;
        [self.searchTextBackView addSubview:_searchDeleteBtn];
        [_searchDeleteBtn addTarget:self action:@selector(coverTextFiledAction:) forControlEvents:UIControlEventTouchUpInside];
        
        [self.searchDeleteBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(8).priorityHigh();
            make.top.bottom.inset(0);
            make.width.equalTo(@30).priorityHigh();
        }];
        
        self.searchTextLab.backgroundColor = [UIColor clearColor];
        [self.searchTextLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(8);
            make.top.bottom.inset(0);
            make.right.inset(24);
        }];
        
        [self.cancleBtn addTarget:self action:@selector(cancleAction:) forControlEvents:UIControlEventTouchUpInside];
    }
    return self;
}

- (void)cancleAction:(UIButton *)btn
{
    if (self.cancleBlock) {
        self.cancleBlock();
    }
}

- (void)coverTextFiledAction:(UIButton *)btn
{
    /// 点击的是删除文字按钮
    if (btn == self.searchDeleteBtn) {
        if (self.touchBlock) {
            self.touchBlock(nil);
        }
    }else{ /// 点击输入框,有可能searchText是nil
        if (self.touchBlock) {
            self.touchBlock(self.searchText);
        }
    }
  
}

- (void)setSearchText:(NSString *)searchText
{
    if (_searchText != searchText) {
        _searchText = searchText;
        if (!searchText || searchText.length == 0) {
            self.searchTextBackView.hidden = YES;
        }else{
            self.searchTextBackView.hidden = NO;
        }
        self.searchTextLab.text = searchText;
    }
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
