//
//  QGSearchMallResultViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/25.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGSearchMallResultViewController.h"
#import "QGSearchMallViewController.h"

#import "QGMallVerticalGoodsCell.h"
#import "QGMallHorizontalGoodsCell.h"

/// sectionView
#import "QGMallSearchSectionView.h"
#import "QGMallSearchBarCoverView.h"

#import "QGCacheManager.h"
#import "QGMallSearchConst.h"



@interface QGSearchMallResultViewController ()
/// 虚假的搜索框
@property (nonatomic, strong)QGMallSearchBarCoverView *searchBarView;

/// 是否隐藏SearchBar,此参数非必传, 默认不隐藏
@property (nonatomic, assign) BOOL hiddenSearchBar;

@property (nonatomic, assign) BOOL hasCoupon;


@end

@implementation QGSearchMallResultViewController

- (BOOL)checkParameters:(NSDictionary *)param
{
    
    NSString * searchText = param[@"searchText"];
    if (![NSString isEmpty:searchText]) {
        return YES;
    }
    return NO;
}

- (void)transferParameters:(NSDictionary *)param
{
    self.searchText = param[@"searchText"];
    self.hiddenSearchBar = [param[@"hiddenSearchBar"] boolValue];
    self.navTitle = param[@"title"];
}


- (void)viewDidLoad {
    [super viewDidLoad];
   
    /// 初始化Navigation
    [self setupNavigation];
    [self setupUI];
    // Do any additional setup after loading the view.
}

/// 设置Navigation
- (void)setupNavigation
{
    [self setNavBarBottomLineHidden:YES];
    /// 如果是hiddenSearchBar,隐藏搜索,直接显示标题
    if (self.hiddenSearchBar) {
        [self custemLeftDefaultBarButtonItem];
        self.title = self.navTitle ? self.navTitle : self.searchText;
    }else{
        
        if (@available(iOS 11.0, *)) {
            self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc]init];
            self.navigationItem.backBarButtonItem = nil;
        }else{
            UIButton *btn = [UIButton buttonWithType:UIButtonTypeCustom];
                btn.frame = CGRectMake(0, 0, 0.5, 44);
            UIBarButtonItem *item = [[UIBarButtonItem alloc]initWithCustomView:btn];
            self.navigationItem.leftBarButtonItems = @[item];
            self.navigationItem.leftBarButtonItem = item;
        }
        
        /// 虚假的搜索框
        self.searchBarView = [[QGMallSearchBarCoverView alloc]initWithFrame:CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width - 32, 44)];
        _searchBarView.searchText = self.searchText;

        self.navigationItem.titleView = self.searchBarView;
        
        /// 本地存储搜索记录,避免遗漏不是从搜索页面进入的情况
        [self saveToLocalWithSearchText:self.searchText];
        
        [self.searchBarView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.width.mas_equalTo([UIScreen mainScreen].bounds.size.width - 32);
            make.height.mas_equalTo(44);
        }];
        
        /// 取消搜索
        @weakify(self);
        _searchBarView.cancleBlock = ^{
            @strongify(self);
            [self.navigationController popViewControllerAnimated:YES];
        };
        
        /// 点击输入框或者删除按钮,点击将会重新present搜索页面
        _searchBarView.touchBlock = ^(NSString * _Nullable text) {
            @strongify(self);
            [self clickSearchBarWithText:text];
        };
    }
}

/// 设置子视图
- (void)setupUI
{
    
    self.isBox = NO;
    
    QGMallSearchSectionItem *item1 = [[QGMallSearchSectionItem alloc]init];
    item1.title = @"综合";
    item1.sortAble = NO;
    
    QGMallSearchSectionItem *item2 = [[QGMallSearchSectionItem alloc]init];
    item2.title = @"券后价";
    item2.sortAble = YES;
    
    
    QGMallSearchSectionItem *item3 = [[QGMallSearchSectionItem alloc]init];
    item3.title = @"销量";
    item3.sortAble = YES;
    item3.downToUp = YES;
    
    self.sectionView.layoutEnable = YES;
    self.sectionView.items = @[item1,item2,item3];
    
    self.sectionView.isBox = self.isBox;
    self.sectionView.hasCouponSwitch = YES;
    [self.view addSubview:self.sectionView];
    [self.sectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop);
        } else {
            make.top.equalTo(self.view.mas_top).inset(64);
            // Fallback on earlier versions
        }
        make.left.right.inset(0);
        make.height.mas_equalTo(70);
    }];
    @weakify(self);
    self.sectionView.switchBlock = ^(BOOL open) {
        @strongify(self);
        self.hasCoupon = open;
        [self.tableView setContentOffset:CGPointMake(0, 0)];
        [self.tableView beginRefresh];
    };
    
    /// 重新布局TableView
    self.tableView.backgroundColor = UIColor.moduleSeparatorColorF7F7;
    [self.tableView mas_remakeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.sectionView.mas_bottom);
        make.left.right.equalTo(self.view);
        make.bottom.equalTo(self.view.mas_bottomMargin);
    }];
    [self.tableView addRefreshWithHandle:^(BOOL isHeaderRefresh) {
        @strongify(self);
        [self requestDataReload:isHeaderRefresh];
    }];
    [self.tableView beginRefresh];
    

}

#pragma mark - Request

- (void)requestDataReload:(BOOL)isReload
{
//    http://yapi.quantgroups.com/mock/305/app/mall/search
    
    if (!self.searchText || self.searchText.length == 0) {
        return;
    }
    if (isReload) {
        self.tableView.pageNum = 1;
    }
    
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    NSMutableDictionary *param = [NSMutableDictionary dictionary];
    [param setObject:self.searchText forKey:@"term"];
    [param setObject:@(self.orderType) forKey:@"orderType"];
    [param setObject:@(self.tableView.pageNum) forKey:@"currentPageNo"];
    [param setObject:@(self.tableView.pageCount) forKey:@"pageSize"];
    [param setObject:@(self.hasCoupon) forKey:@"hasCoupon"];
    
    [networking GET:[QGMallRequestApi urlWithIndex:QGMallRequestServerMethodSearch] parameters:param success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *dic = responseObject[@"data"];
            NSArray *list = dic[@"goodsList"];
            BOOL hasNext = [dic[@"hasNext"] boolValue];
            if (isReload) {
                [self.dataSource removeAllObjects];
            }
            for (NSDictionary *dictionary in list) {
                QGMallBaseGoodsModel *model = [QGMallBaseGoodsModel yy_modelWithDictionary:dictionary];
                if (model) {
                     [self.dataSource addObject:model];
                }
            }
            [self.tableView reloadData];
            [self.tableView endRefreshWithBusinessSuccess:YES hasNext:hasNext];
            
        }else{
             [self.tableView endRefreshWithBusinessSuccess:NO hasNext:YES];
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [self networkErrorPageWithPageNum:self.tableView.pageNum responseObject:nil error:error];
    }];
}

#pragma mark - SearchBar 点击事件

- (void)clickSearchBarWithText:(NSString *)text
{
    QGSearchMallViewController *searchVC = [[QGSearchMallViewController alloc]init];
    searchVC.searchText = text;
    @weakify(self);
    searchVC.rollBackBlock = ^(NSString * _Nonnull searchText) {
        @strongify(self);
        self.searchText = searchText;
        self.searchBarView.searchText = searchText;
        [self.tableView setContentOffset:CGPointMake(0, 0) animated:NO];
        [self requestDataReload:YES];
        
    };
    [self presentViewController:searchVC animated:NO completion:NULL];
}

/// 保存搜索历史
/// @param text 搜索的关键词
- (void)saveToLocalWithSearchText:(NSString *)text
{
    if (!text || text.length == 0) return;
    /// 保存搜索历史数据
    QGCacheManager *manager = [QGCacheManager shareCacheManager];
    NSArray *list = [manager userConfigInfoValueForKey:kMallSearchHistoryList];
    NSMutableArray *aList = [NSMutableArray arrayWithArray:list];
    if (![aList containsObject:text]) { /// 不包含直接存储
        [aList insertObject:text atIndex:0];
    }else{  /// 已包含把搜索词提前到第一位
        if ([aList indexOfObject:text] != 0) {
            [aList removeObject:text];
            [aList insertObject:text atIndex:0];
        }
    }
    [manager setUserConfigInfoValue:aList forKey:kMallSearchHistoryList];
}

/// 去商品详情页
- (void)goToGoodsDetail:(QGMallBaseGoodsModel *)goodsModel
{
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGMallGoodsDetailViewController) parameters:@{@"goodsId":goodsModel.goodsId} handlerBlock:nil];
    
     /// 搜索结果页统计
      QGAppCoreModelClickEvent * event = [QGAppCoreModelClickEvent acmcEventWithPage:@"搜索结果页" path:@"搜索结果" name:@"搜索结果" detail_name:goodsModel.goodsId  acmc_model_other:goodsModel.goodsName];
       [QGAnalyticsService analyticsTrackWithEvent:event];
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
