//
//  QGSearchContentViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/25.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGSearchContentViewController.h"
#import "QGSearchMallResultViewController.h"

#import "QGMallSearchBarView.h"
#import "QGMallSearchTipView.h"
#import "QGMallSearchHistorySectionView.h"
#import "QGAlertView.h"

#import "QGMallSearchHistoryCollectionCell.h"
#import "QGMallSearchHistoryLeftFlowLayout.h"

#import "QGMallSearchModel.h"
#import "QGCacheManager.h"

#import "QGMallSearchConst.h"

#import "QGMallRequestApi.h"


@interface QGSearchContentViewController ()<UICollectionViewDelegate,UICollectionViewDataSource>

@property (nonatomic, strong)QGMallSearchBarView *searchBarView ;

@property (nonatomic, strong)UICollectionView *collectionView;

@property (nonatomic, strong)NSMutableArray *dataSource;

@end

@implementation QGSearchContentViewController

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    if (@available(iOS 11.0, *)) {
       
    }else{
        /// 在iPhone 5s 10.2 上,self.collectionView reloadData 不起作用,添加这行代码
        [self.collectionView reloadData];
    }
    [self.searchBarView becomeFirstResponder];
}

- (void)viewWillDisappear:(BOOL)animated
{
    [super viewWillDisappear:animated];
    [self.searchBarView resignFirstResponder];
}

- (void)viewDidLoad {
    [super viewDidLoad];
   
    self.dataSource = [NSMutableArray arrayWithCapacity:2];
    [self initNavgationSearchBar];
    [self setupUI];
    
    // Do any additional setup after loading the view.
}

- (void)initNavgationSearchBar
{
    [self setNavBarBottomLineHidden:YES];
    self.searchBarView = [[QGMallSearchBarView alloc]initWithFrame:CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width - 24, 44)];
    /// 自动填充"上次输入的文字"
    if (self.searchText) {
        _searchBarView.searchText = self.searchText;
    }
    self.navigationItem.leftBarButtonItem = nil;
    self.navigationItem.backBarButtonItem = nil;
    self.navigationItem.leftBarButtonItems = nil;
    self.navigationItem.rightBarButtonItem = nil;
    
    self.navigationItem.titleView = _searchBarView;
    /// 取消搜索
    @weakify(self);
    _searchBarView.cancleBlock = ^{
        @strongify(self);
        [self.searchBarView resignFirstResponder];
        [self.navigationController dismissViewControllerAnimated:YES completion:NULL];
    };
    /// 开始搜索
    _searchBarView.searchBlock = ^(NSString * _Nonnull text) {
        @strongify(self);
        [self beaginSearchWithText:text];
    };
       
    [_searchBarView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo([UIScreen mainScreen].bounds.size.width - 24);
        make.height.mas_equalTo(44);
    }];
    
}


- (void)setupUI
{
    
    QGMallSearchTipView *headerView = [[QGMallSearchTipView alloc]init];
    [self.view addSubview:headerView];
    
    [headerView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.equalTo(self.view);
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop).inset(24);
        } else {
            make.top.equalTo(self.view.mas_top).inset(88);
            // Fallback on earlier versions
        }
        make.height.mas_equalTo(55);
    }];
    //搜索历史列表
    QGMallSearchHistoryLeftFlowLayout *layout = [[QGMallSearchHistoryLeftFlowLayout alloc]init];
    
    self.collectionView = [[UICollectionView alloc]initWithFrame:CGRectMake(0, 0, [UIScreen mainScreen].bounds.size.width, self.view.frame.size.height) collectionViewLayout:layout];
    _collectionView.delegate = self;
    _collectionView.dataSource = self;
    _collectionView.backgroundColor = UIColor.whiteColor;
    [self.view addSubview:self.collectionView];
    [_collectionView registerClass:[QGMallSearchHistoryCollectionCell class] forCellWithReuseIdentifier:@"QGMallSearchHistoryCollectionCell"];
    [self.collectionView registerClass:[QGMallSearchHistorySectionView class] forSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"QGMallSearchHistoryCollectionHeader"];
    
    [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(headerView.mas_bottom).offset(15);
        make.left.right.bottom.equalTo(self.view).inset(0);
    }];
    
    /// 装载历史搜索数据
    QGCacheManager *manager = [QGCacheManager shareCacheManager];
    NSArray *list = [manager userConfigInfoValueForKey:kMallSearchHistoryList];
    if (list.count > 100) {
        /// 初始化数据的时候剪切一下数据,防止数据量过多
        NSArray *lowList = [list subarrayWithRange:NSMakeRange(0, 100)];
        /// 存储到本地
        [manager setUserConfigInfoValue:lowList forKey:kMallSearchHistoryList];
    }
    
    NSArray *caList = [self calculateLineNumberWithArray:list];
    if (list.count) {
        QGMallSearchModel *historys = [[QGMallSearchModel alloc]init];
        historys.title = @"历史搜索";
        historys.list = caList;
        historys.deleteAble = YES;
        [self.dataSource addObject:historys];
    }
    
    [self requestRecommendSearch];
}


/// 请求大家都在搜
- (void)requestRecommendSearch
{
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    
    [networking GET:[QGMallRequestApi urlWithIndex:QGMallRequestServerMethodHotSearches] parameters:nil success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *dic = responseObject[@"data"];
            NSArray *list = dic[@"terms"];
            NSArray *caList =  [self calculateLineNumberWithArray:list];
            if (caList.count) {
                QGMallSearchModel *hotSearches = [[QGMallSearchModel alloc]init];
                hotSearches.title = @"大家都在搜";
                hotSearches.list = caList;
                hotSearches.deleteAble = NO;
                [self.dataSource addObject:hotSearches];
            }
            dispatch_async(dispatch_get_main_queue(), ^{
                [self.collectionView reloadData];
            });
        }
        NSLog(@"%@",responseObject);
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSLog(@"网络错误");
    }];
}



/// 计算4行文字所需要的文字数组
/// @param list 原始数组
- (NSArray *)calculateLineNumberWithArray:(NSArray *)list
{
    if (list.count == 0) return nil;
    CGFloat x = 0;
    NSInteger line = 1;
    CGFloat cellInset = 6.0f;
    /// cell的左右边距是15,所以对比的时候-30
    CGFloat screenWith = [UIScreen mainScreen].bounds.size.width - 30;
    NSMutableArray *dataArray = [NSMutableArray array];
    
    for (int i = 0; i < list.count; i++) {
        NSString *text = list[i];
        /// 文字所占的宽度 因为左右边距是8,所以+16
        CGFloat textLength = [text boundingRectWithSize:CGSizeMake(MAXFLOAT, 15.0f) options:NSStringDrawingUsesLineFragmentOrigin | NSStringDrawingUsesFontLeading attributes:@{NSFontAttributeName:[UIFont qg_regularFontOfSize:13.0f]} context:nil].size.width + 16;
        /// 换行
        if (x + textLength + cellInset > screenWith) {
            line += 1;
            x = 0;
        }
        if (line >= 5) { //等于5行时不再增加
            break;
        }
        /// 加上当前行的距离
        x += textLength;
        x += cellInset;
        [dataArray addObject:text];
       
    }
    return  dataArray;
}

#pragma mark - Collection Delegate & DataSource

- (NSInteger)numberOfSectionsInCollectionView:(UICollectionView *)collectionView
{
    return self.dataSource.count;
}

- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    QGMallSearchModel *model = self.dataSource[section];
    return model.list.count;
}

// The cell that is returned must be retrieved from a call to -dequeueReusableCellWithReuseIdentifier:forIndexPath:
- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGMallSearchHistoryCollectionCell *cell = [collectionView dequeueReusableCellWithReuseIdentifier:@"QGMallSearchHistoryCollectionCell" forIndexPath:indexPath];
    QGMallSearchModel *model = self.dataSource[indexPath.section];
    NSLog(@"%@",model.list);
    cell.title = model.list[indexPath.row];
    return cell;
}

- (UICollectionReusableView *)collectionView:(UICollectionView *)collectionView viewForSupplementaryElementOfKind:(NSString *)kind atIndexPath:(NSIndexPath *)indexPath
{
    if ([kind isEqualToString:UICollectionElementKindSectionHeader]) {
        QGMallSearchHistorySectionView *header = [collectionView dequeueReusableSupplementaryViewOfKind:UICollectionElementKindSectionHeader withReuseIdentifier:@"QGMallSearchHistoryCollectionHeader" forIndexPath:indexPath];
        QGMallSearchModel *model = self.dataSource[indexPath.section];
        header.title = model.title;
        header.deleteAble = model.deleteAble;
        @weakify(self);
        header.deleteBlock = ^{
            @strongify(self);
            [self askDeleteHistorySearch];
        };
        return header;
    }
    return nil;
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout referenceSizeForHeaderInSection:(NSInteger)section{
     CGFloat screenWidth = [UIScreen mainScreen].bounds.size.width;
     return CGSizeMake(screenWidth, 45);
}

- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    [collectionView deselectItemAtIndexPath:indexPath animated:YES];
    [self.view endEditing:YES];
    /// 选中效果
    QGMallSearchModel *model = self.dataSource[indexPath.section];
    NSString *text = model.list[indexPath.row];
    if (text) {
        self.searchBarView.searchText = text;
        [self beaginSearchWithText:text];
    }
    /// 搜索点击统计
    QGAppCoreModelClickEvent *event = nil;
    if ([model.title isEqualToString:@"历史搜索"]) {
        event = [QGAppCoreModelClickEvent acmcEventWithPage:@"搜索页" path:@"历史搜索" name:@"历史搜索" detail_name:nil  acmc_model_other:text];
    }else{
        event = [QGAppCoreModelClickEvent acmcEventWithPage:@"搜索页" path:@"大家都在搜" name:@"大家都在搜" detail_name:nil  acmc_model_other:text];
    }
    [QGAnalyticsService analyticsTrackWithEvent:event];
}

- (void)scrollViewWillBeginDragging:(UIScrollView *)scrollView
{
    if (self.searchBarView) {
        [self.searchBarView resignFirstResponder];
    }
}


/// 询问是否删除历史数据
- (void)askDeleteHistorySearch
{
    [self.searchBarView resignFirstResponder];
    @weakify(self);
    QGAlertView *alert = [[QGAlertView alloc]initWithTitle:@"提示" message:@"您确认要删除历史搜索吗?" cancelButtonTitle:@"取消" sureButtonTitle:@"确认" clickBlock:^(NSInteger index) {
        @strongify(self);
        if (index == 1) {
            [self commitDeleteHistorySearch];
        }
    }];
    [alert showInView:self.view];
}

/// 删除搜索历史
- (void)commitDeleteHistorySearch
{
    NSLog(@"commitDeleteHistorySearch");
    
    QGCacheManager *manager = [QGCacheManager shareCacheManager];
    [manager removeUserConfigWithKeys:@[kMallSearchHistoryList]];
    
    [self.dataSource enumerateObjectsWithOptions:NSEnumerationReverse usingBlock:^(QGMallSearchModel *  _Nonnull model, NSUInteger idx, BOOL * _Nonnull stop) {
        if ([model.title isEqualToString:@"历史搜索"]) {
            [self.dataSource removeObject:model];
            [self.collectionView reloadData];
            *stop = YES;
        }
    }];
    
}


#pragma mark - 开始搜索

- (void)beaginSearchWithText:(NSString *)text
{
    if (!text) return;
    /// 搜索历史存到本地
    [self saveToLocalWithSearchText:text];
    [self.searchBarView resignFirstResponder];
    if (self.rollBackBlock) {
        [self.navigationController dismissViewControllerAnimated:NO completion:^{
            self.rollBackBlock(text);
        }];
    }else{
        /// 跳转详情数据
        QGSearchMallResultViewController *searchResultVC = [[QGSearchMallResultViewController alloc]init];
        searchResultVC.searchText = text;
        [self.navigationController pushViewController:searchResultVC animated:YES];
    }
}

- (void)saveToLocalWithSearchText:(NSString *)text
{
    /// 保存搜索历史数据
    QGCacheManager *manager = [QGCacheManager shareCacheManager];
    
    NSArray *list = [manager userConfigInfoValueForKey:kMallSearchHistoryList];
    NSMutableArray *aList = [NSMutableArray arrayWithArray:list];
    if (![aList containsObject:text]) {
        [aList insertObject:text atIndex:0];
        /// 刷新页面
        __block BOOL hasHistory = NO;
        [self.dataSource enumerateObjectsUsingBlock:^(QGMallSearchModel *  _Nonnull model, NSUInteger idx, BOOL * _Nonnull stop) {
            if ([model.title isEqualToString:@"历史搜索"]) {
                hasHistory = YES;
                model.list = [self calculateLineNumberWithArray:aList];
                *stop = YES;
            }
        }];
        
        if (!hasHistory) {
            QGMallSearchModel *history = [[QGMallSearchModel alloc]init];
            history.title = @"历史搜索";
            history.deleteAble = YES;
            history.list = [self calculateLineNumberWithArray:aList];
            [self.dataSource insertObject:history atIndex:0];
        }
        
        [self.collectionView reloadData];
    }else{  /// 如果搜索历史已经包含了这个内容,并且不在第一位
        if ([aList indexOfObject:text] != 0) {
            [aList removeObject:text];
             [aList insertObject:text atIndex:0];
             [self.dataSource enumerateObjectsUsingBlock:^(QGMallSearchModel *  _Nonnull model, NSUInteger idx, BOOL * _Nonnull stop) {
                 if ([model.title isEqualToString:@"历史搜索"]) {
                     model.list = [self calculateLineNumberWithArray:aList];
                     *stop = YES;
                 }
             }];
             [self.collectionView reloadData];
        }
    }
    /// 存储到本地
    [manager setUserConfigInfoValue:aList forKey:kMallSearchHistoryList];
    
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
