//
//  QGMallSearchHistorySectionView.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallSearchHistorySectionView.h"
#import "QGBasicUITool.h"

@interface QGMallSearchHistorySectionView ()

/// 标题
@property (nonatomic, strong) UILabel *titleLab ;
/// 删除按钮
@property (nonatomic, strong) UIButton *deleteBtn ;

@end

@implementation QGMallSearchHistorySectionView

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        [self setups];
    }
    return self;
}
/// 子视图设置
- (void)setups
{
    /// 标题
    self.titleLab = [UIView creatLabelWithSuperView:self title:@"标题" titleFontSize:[UIFont qg_mediumFontOfSize:14.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentLeft];
    [self.titleLab mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(0);
        make.centerY.equalTo(self);
    }];
    /// 删除按钮
    self.deleteBtn = [UIButton buttonWithType:UIButtonTypeCustom];
    [_deleteBtn setImage:[UIImage imageNamed:@"mall_history_delete"] forState:UIControlStateNormal];
    _deleteBtn.contentHorizontalAlignment = UIControlContentHorizontalAlignmentRight;
    [self addSubview:_deleteBtn];
    
    [_deleteBtn addTarget:self action:@selector(deleteAction:) forControlEvents:UIControlEventTouchUpInside];
    
    [self.deleteBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.inset(30);
        make.centerY.equalTo(self.titleLab);
        make.width.greaterThanOrEqualTo(@60);
    }];
}

- (void)deleteAction:(UIButton *)btn
{
    if (self.deleteBlock) {
        self.deleteBlock();
    }
}

- (void)setTitle:(NSString *)title
{
    _title = title;
    self.titleLab.text = title;
}

- (void)setDeleteAble:(BOOL)deleteAble
{
    _deleteAble = deleteAble;
    self.deleteBtn.hidden = !deleteAble;
}

/*
// Only override drawRect: if you perform custom drawing.
// An empty implementation adversely affects performance during animation.
- (void)drawRect:(CGRect)rect {
    // Drawing code
}
*/

@end
