//
//  QGMallSearchHistoryCollectionCell.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallSearchHistoryCollectionCell.h"
#import "QGBasicUITool.h"

@interface QGMallSearchHistoryCollectionCell ()
/// 历史标题
@property (nonatomic, strong)UILabel *textLab;

@end

@implementation QGMallSearchHistoryCollectionCell

- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        /// 灰色背景
        UIView *backView = [UIView creatViewWithSuperView:self backgroundColor:UIColor.moduleSeparatorColorF7F7];
        backView.layer.cornerRadius = 12.5;
        backView.clipsToBounds = YES;
        [backView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.equalTo(self);
            make.width.greaterThanOrEqualTo(@40);
        }];
        
       /// 历史标题
        self.textLab = [UIView creatLabelWithSuperView:backView title:nil titleFontSize:[UIFont qg_regularFontOfSize:13.0f] textColor:UIColor.textColor3333 alignment:NSTextAlignmentCenter];
     
        [self.textLab mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.bottom.inset(0);
            make.left.right.inset(8);
            make.width.lessThanOrEqualTo(@([UIScreen mainScreen].bounds.size.width - 48));
            make.height.mas_equalTo(25);
        }];
        
    }
    return self;
}

- (void)setTitle:(NSString *)title
{
    if (_title != title) {
        _title = title;
    }
    self.textLab.text = title;
}

@end
