//
//  QGMallOperateBannerCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/27.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallOperateBannerCell.h"
#import "QGBasicUITool.h"
#import "QGBannerView.h"

@interface QGMallOperateBannerCell () <QGBannerViewDelegate>

/// 图片数组视图
@property (nonatomic, strong) QGBannerView * bannerView;

@end

@implementation QGMallOperateBannerCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        //初始化banner
        self.bannerView = [QGBannerView bannerViewWithFrame:CGRectMake(0, 0, MAINSCREEN_WIDTH, (MAINSCREEN_WIDTH) * (100/375.0)) delegate:self placeholderImage:[UIImage imageNamed:@"mall_common_placeholder"]];
        self.bannerView.autoScrollTimeInterval = 5;
        [self.contentView addSubview:self.bannerView];
        
    }
    return self;
}

#pragma mark - QGBannerViewDelegate
/** 点击图片回调 */
- (void)bannerView:(QGBannerView *)bannerView didSelectItemAtIndex:(NSInteger)index
{
    if (self.bannerClickBlock) {
        if (self.bannerListModel.headerBannerList.count > index) {
            self.bannerClickBlock(index, self.bannerListModel.headerBannerList[index]);
        }
    }
}


- (void)setBannerListModel:(QGOperateBannerListModel *)bannerListModel
{
    if (_bannerListModel != bannerListModel) {
        _bannerListModel = bannerListModel;
        
        //设置图片数组
        NSMutableArray * urlArray = [NSMutableArray arrayWithCapacity:0];
        for (QGOperateBannerModel * bannerModel in bannerListModel.headerBannerList) {
            [urlArray addObject:bannerModel.icon];
        }
        self.bannerView.imageUrlArray = urlArray;
        self.contentView.backgroundColor = [UIColor colorWithHexString:bannerListModel.backgroundColor];
    }
}


@end
