//
//  QGMallHomepageQuickEntryCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/25.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallHomepageQuickEntryCell.h"

#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGMallHomepageQuickEntryCell () <UICollectionViewDelegate, UICollectionViewDataSource>

/// 承载视图
@property (nonatomic, strong) UICollectionView * collectionView;
@end

@implementation QGMallHomepageQuickEntryCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //承载视图
        UICollectionViewFlowLayout * layout = [[UICollectionViewFlowLayout alloc] init];
        layout.scrollDirection = UICollectionViewScrollDirectionVertical;
        layout.itemSize = CGSizeMake(MAINSCREEN_WIDTH/5, 92);
        layout.minimumInteritemSpacing = 0;
        layout.minimumLineSpacing = 0;
        
        self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        self.collectionView.delegate = self;
        self.collectionView.dataSource = self;
        self.collectionView.backgroundColor = [UIColor whiteColor];
        self.collectionView.scrollEnabled = NO;
        [self.contentView addSubview:self.collectionView];
        
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(0);
            make.top.inset(0);
            make.bottom.inset(0);
        }];
        
        //注册cell
        [self.collectionView registerClass:[QGMallQuickEntryCollectionCell class] forCellWithReuseIdentifier:NSStringFromClass([QGMallQuickEntryCollectionCell class])];
        
    }
    return self;
}


#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return MIN(self.tempModel.quickEntryList.count, 10);
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGMallQuickEntryCollectionCell * cell = (QGMallQuickEntryCollectionCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGMallQuickEntryCollectionCell class]) forIndexPath:indexPath];
    QGQuickEntryModel * model = self.tempModel.quickEntryList[indexPath.row];
    
    cell.titleLabel.text = model.name;
    [cell.iconImgView setMallImageByNomalPlaceholderWithURLString:model.icon];
    return cell;
}

#pragma mark - UICollectionViewDelegate
- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.quickEntryClickBlock) {
        self.quickEntryClickBlock(indexPath.row, self.tempModel.quickEntryList[indexPath.row]);
    }
}


#pragma mark - Setter
- (void)setTempModel:(QGMallQuickEntryTempModel *)tempModel
{
    if (_tempModel != tempModel) {
        _tempModel = tempModel;
        [self.collectionView reloadData];
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end


/// 快捷入口子视图
@implementation QGMallQuickEntryCollectionCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //图标
        self.iconImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.iconImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(48, 48));
            make.top.inset(10);
            make.centerX.offset(0);
        }];
//        self.iconImgView.layer.cornerRadius = 48/2.0;
        self.iconImgView.clipsToBounds = YES;
        
        //文案
        self.titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.top.mas_equalTo(self.iconImgView.mas_bottom).offset(7);
            make.height.mas_equalTo(17);
        }];
    }
    return self;
}

@end

