//
//  QGOperateStyleInfoModel.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGOperateStyleInfoModel.h"
#import "QGAppMacro.h"
@implementation QGOperateStyleInfoModel

+ (NSDictionary *)modelContainerPropertyGenericClass {
    return @{@"adBannerList" : [QGOperateInfoModel class]};
}


+ (NSArray *)modelPropertyBlacklist {
    return @[@"cellHeight"];
}


- (CGFloat)cellHeight
{
    if (_cellHeight == 0 && self.adBannerList.count > 0) {
        QGOperateInfoModel * infoModel = self.adBannerList.firstObject;
        _cellHeight = infoModel.cellSize.height + 5;
    }
    return _cellHeight;
}

@end

@implementation QGOperateInfoModel

+ (NSArray *)modelPropertyBlacklist {
    return @[@"cellSize"];
}

- (CGSize)cellSize
{
    if (CGSizeEqualToSize(_cellSize, CGSizeZero)) {
        CGFloat imageWidth = (MAINSCREEN_WIDTH/2.0 - 25);
        CGFloat imageHeight = 80/163.0 * imageWidth;
        _cellSize = CGSizeMake((MAINSCREEN_WIDTH/2.0 - 15), 59 + imageHeight + 11);
    }
    return _cellSize;
}


@end
