//
//  QGOperateStyleImgModel.m
//  VirtualPayment
//
//  Created by 张博 on 2020/3/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGOperateStyleImgModel.h"
#import "QGAppMacro.h"
@implementation QGOperateStyleImgListModel

+ (NSDictionary *)modelContainerPropertyGenericClass {
    return @{@"partBannerList" : [QGOperateStyleImgModel class]};
}

+ (NSArray *)modelPropertyBlacklist {
    return @[@"cellHeight"];
}


- (CGFloat)cellHeight
{
    if (_cellHeight == 0 && self.partBannerList.count > 0) {
        QGOperateStyleImgModel * imgModel = self.partBannerList.firstObject;
        _cellHeight = imgModel.cellSize.height + 5;
    }
    return _cellHeight;
}

@end

@implementation QGOperateStyleImgModel

+ (NSArray *)modelPropertyBlacklist {
    return @[@"cellSize"];
}

- (CGSize)cellSize
{
    if (CGSizeEqualToSize(CGSizeZero, _cellSize)) {
        CGFloat imageWidth = (MAINSCREEN_WIDTH - 15 * 2 - 5)/2.0;
        CGFloat imageHeight = imageWidth/22.0 * 9;
        _cellSize = CGSizeMake(imageWidth, imageHeight);
    }
    return _cellSize;
}

@end


