//
//  QGMallGoodsDetailPromoterCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/4/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallGoodsDetailPromoterCell.h"
#import "QGBasicUITool.h"
#import "QGGradientView.h"
#import "QGDesignatedCornerView.h"

@interface QGMallGoodsDetailPromoterCell ()


/// 打开按钮
@property (nonatomic, strong, readwrite) QGGradientShadowButton * openButton;

/// 标题文案
@property (nonatomic, strong) UILabel * titleLabel;

///
@property (nonatomic, strong) QGGradientView * gradientContentView;

@end

@implementation QGMallGoodsDetailPromoterCell


- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        self.clipsToBounds = YES;
        
        //渐变色
        self.gradientContentView = [[QGGradientView alloc] init];
        self.gradientContentView.gradientLayer.colors = [UIColor gradientColorsE9B176ToF2CD8B];
        self.gradientContentView.layer.cornerRadius = 6;
        self.gradientContentView.clipsToBounds = YES;
        [self.contentView addSubview:self.gradientContentView];
        [self.gradientContentView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.inset(15);
            make.bottom.inset(2);
            make.left.right.inset(15);
        }];
        
        //标题
        self.titleLabel = [UILabel creatLabelWithSuperView:self.gradientContentView title:nil titleFontSize:[UIFont qg_lightFontOfSize:12] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
        [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.centerY.offset(0);
         }];
        
        [self.titleLabel setContentCompressionResistancePriority:UILayoutPriorityDefaultLow forAxis:UILayoutConstraintAxisHorizontal];
                
        //打开按钮
        self.openButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.gradientContentView title:nil textFont:[UIFont qg_regularFontOfSize:12]];
        self.openButton.backgroundColor = [UIColor colorWithHexString:@"2D2323"];
        self.openButton.layer.cornerRadius = 12;
        self.openButton.clipsToBounds = YES;
        [self.gradientContentView addSubview:self.openButton];
        [self.openButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(24);
            make.right.inset(10);
            make.centerY.offset(0);
            make.left.mas_greaterThanOrEqualTo(self.titleLabel.mas_right).offset(10);
        }];
    
    }
    return self;
}


/// 设置推广描述和用户级别
/// @param promoterEarnDesc 推广描述
/// @param promoterLevel 用户级别
- (void)setPromoterEarnDesc:(NSString *)promoterEarnDesc promoterLevel:(NSString *)promoterLevel
{
    self.titleLabel.text = promoterEarnDesc;
    //普通用户
    if (promoterLevel.integerValue == 1) {
        [self.openButton setTitle:@"  去升级>>  " forState:UIControlStateNormal];
        self.openButton.gradientLayer.colors = @[(id)[UIColor colorWithHexString:@"2D2323"].CGColor,(id)[UIColor colorWithHexString:@"2D2323"].CGColor];
        self.gradientContentView.gradientLayer.colors = [UIColor gradientColorsE9B176ToF2CD8B];
    }
    //其他用户
    else
    {
        [self.openButton setTitle:@"  分享赚收益>>  " forState:UIControlStateNormal];
        self.openButton.gradientLayer.colors = [UIColor gradientColorsE9B176ToF2CD8B];
        self.gradientContentView.gradientLayer.colors = @[(id)[UIColor colorWithHexString:@"F7F7F7"].CGColor,(id)[UIColor colorWithHexString:@"F7F7F7"].CGColor];
    }
    
}



@end
