//
//  QGMallGoodsDetailInfoCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallGoodsDetailInfoCell.h"
#import "QGPasteboardLabel.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGMallGoodsDetailInfoCell ()

/// 售卖价格
@property (nonatomic, strong) UILabel * goodsSalePriceLabel;

/// 原价格
@property (nonatomic, strong) UILabel * goodsPriceLabel;

/// 返现推广文案
@property (nonatomic, strong) UIView * promoterView;

/// 推广图片
@property (nonatomic, strong) UIImageView * promoterImgView;

/// 推广金额计算规则
@property (nonatomic, strong) UILabel * promoterAmountLabel;

/// 推广详情
@property (nonatomic, strong) UILabel * promoterDescLabel;

/// 商品名称
@property (nonatomic, strong) QGPasteboardLabel * goodsNameLabel;

/// 预估返现
@property (nonatomic, strong) UILabel * expectEarnLabel;

/// 渠道图片
@property (nonatomic, strong) UIImageView * channelImgView;

/// 快递
@property (nonatomic, strong) UILabel * shipFeeLabel;

/// 销量
@property (nonatomic, strong) UILabel * saleCountLabel;

/// 商品归属地
@property (nonatomic, strong) UILabel * provcityLabel;

@end


@implementation QGMallGoodsDetailInfoCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //券后标题
        UILabel * salePriceTitleLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"券后" titleFontSize:[UIFont qg_mediumFontOfSize:15] textColor:[UIColor yyMainThemeColor] alignment:NSTextAlignmentLeft];
        [salePriceTitleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.height.mas_equalTo(21);
            make.top.inset(17);
        }];
        
        //售卖价格
        self.goodsSalePriceLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:nil textColor:nil alignment:NSTextAlignmentLeft];
        [self.goodsSalePriceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(salePriceTitleLabel.mas_right).offset(3);
            make.top.inset(3);
            make.height.mas_equalTo(42);
        }];
        
        //原价
        self.goodsPriceLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.goodsPriceLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.goodsSalePriceLabel.mas_right).offset(5);
            make.centerY.mas_equalTo(self.goodsSalePriceLabel).offset(5);
            make.height.mas_equalTo(20);
        }];
        
        //划线
        UIView * priceLineView = [UIView creatViewWithSuperView:self.goodsPriceLabel backgroundColor:self.goodsPriceLabel.textColor];
        [priceLineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.height.mas_equalTo(1);
            make.left.right.inset(-2);
            make.centerY.offset(0);
        }];
        
        //预估返现
        self.expectEarnLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:12] textColor:[UIColor whiteColor] alignment:NSTextAlignmentCenter];
        self.expectEarnLabel.layer.cornerRadius = 3;
        self.expectEarnLabel.clipsToBounds = YES;
        self.expectEarnLabel.backgroundColor = [UIColor yyMainThemeColor];
        [self.expectEarnLabel mas_updateConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.centerY.mas_equalTo(self.goodsSalePriceLabel);
            make.height.mas_equalTo(19);
        }];
        
        //返现推广文案视图
        self.promoterView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[[UIColor yyMainThemeColor] colorWithAlphaComponent:0.05]];
        [self.promoterView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.mas_equalTo(self.goodsSalePriceLabel.mas_bottom).offset(-3);
            make.height.mas_equalTo(55);
        }];
        [self addPromoterViewMaskLayer:self.promoterView];
        
        //推广图片
        self.promoterImgView = [UIImageView creatImageViewWithSuperView:self.promoterView imageName:nil];
        [self.promoterImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(7);
            make.size.mas_equalTo(CGSizeMake(66, 31));
            make.top.inset(15);
        }];
        
        //推广标题
        self.promoterAmountLabel = [UILabel creatLabelWithSuperView:self.promoterView title:nil titleFontSize:nil textColor:nil alignment:NSTextAlignmentLeft];
        [self.promoterAmountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(self.promoterImgView.mas_right).offset(5);
            make.right.inset(5);
            make.top.inset(13);
            make.height.mas_equalTo(17);
        }];
        
        //推广详情
        self.promoterDescLabel = [UILabel creatLabelWithSuperView:self.promoterView title:nil titleFontSize:[UIFont qg_regularFontOfSize:10] textColor:[UIColor colorWithHexString:@"E9B176"] alignment:NSTextAlignmentLeft];
        [self.promoterDescLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.mas_equalTo(self.promoterAmountLabel);
            make.top.mas_equalTo(self.promoterAmountLabel.mas_bottom).offset(2);
            make.height.mas_equalTo(14);
        }];
        
        
        //渠道图片
        self.channelImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.channelImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.top.mas_equalTo(self.goodsSalePriceLabel.mas_bottom).offset(11);
            make.size.mas_equalTo(CGSizeMake(24, 12));
        }];
        
        //商品名称
        self.goodsNameLabel = [[QGPasteboardLabel alloc] init];
        [self.contentView addSubview:self.goodsNameLabel];
        self.goodsNameLabel.font = [UIFont qg_regularFontOfSize:16];
        self.goodsNameLabel.textColor = [UIColor textColor9999];
        self.goodsNameLabel.numberOfLines = 0;
        [self.goodsNameLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(15);
            make.top.mas_equalTo(self.channelImgView.mas_top).offset(-6);
        }];
        
        //快递
        self.shipFeeLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:[UIFont qg_regularFontOfSize:13] textColor:[UIColor textColor9999] alignment:NSTextAlignmentLeft];
        [self.shipFeeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(15);
            make.top.mas_equalTo(self.goodsNameLabel.mas_bottom).offset(8);
            make.height.mas_equalTo(18);
        }];
        
        //销量
        self.saleCountLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:self.shipFeeLabel.font textColor:self.shipFeeLabel.textColor alignment:self.shipFeeLabel.textAlignment];
        [self.saleCountLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.height.top.mas_equalTo(self.shipFeeLabel);
        }];
        
        //商品归属地
        self.provcityLabel = [UILabel creatLabelWithSuperView:self.contentView title:nil titleFontSize:self.shipFeeLabel.font textColor:self.shipFeeLabel.textColor alignment:self.shipFeeLabel.textAlignment];
        [self.provcityLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.height.top.mas_equalTo(self.shipFeeLabel);
        }];
        
        
        
    }
    return self;
}


- (void)setDetailInfoModel:(QGGoodsDetailModel *)detailInfoModel
{
    if (_detailInfoModel != detailInfoModel) {
        _detailInfoModel = detailInfoModel;
        
        self.goodsSalePriceLabel.attributedText = detailInfoModel.showDetailSalePriceStr;
        self.expectEarnLabel.text = [NSString stringWithFormat:@"预估返%@元  ",detailInfoModel.expectEarnAmount];
        self.goodsPriceLabel.text = [NSString stringWithFormat:@"¥%@",detailInfoModel.goodsPrice];
        self.goodsNameLabel.attributedText = detailInfoModel.goodsNameTool.getResultString;
        self.shipFeeLabel.text = [NSString stringWithFormat:@"快递:%@",detailInfoModel.shipFee];
        self.saleCountLabel.text = [NSString stringWithFormat:@"销量:%@",detailInfoModel.saleCount];
        self.provcityLabel.text = detailInfoModel.provcity;
        [self.channelImgView setMallImageByNomalPlaceholderWithURLString:detailInfoModel.channelImg];
        
        //控件显示和隐藏的逻辑
        self.expectEarnLabel.hidden = [NSString isEmpty:detailInfoModel.expectEarnAmount];
        if ([NSString isEmpty:detailInfoModel.goodsPrice]) {
            self.goodsPriceLabel.hidden = YES;
        }
        else
        {
            self.goodsPriceLabel.hidden = NO;
        }
        
        //存在推广提升模型，则展示
        if (detailInfoModel.promoterTips) {
            [self.channelImgView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.top.mas_equalTo(self.goodsSalePriceLabel.mas_bottom).offset(69);
            }];
            self.promoterView.hidden = NO;
            [self.promoterImgView setMallImageByNomalPlaceholderWithURLString:detailInfoModel.promoterTips.promoterImg];
            self.promoterAmountLabel.attributedText = detailInfoModel.promoterTips.showPromoterAmountTitleStr;
            self.promoterDescLabel.text = detailInfoModel.promoterTips.promoterDesc;
        }
        else
        {
            [self.channelImgView mas_updateConstraints:^(MASConstraintMaker *make) {
                make.top.mas_equalTo(self.goodsSalePriceLabel.mas_bottom).offset(11);
            }];
            self.promoterView.hidden = YES;
        }
        
        
    }
}




/// 添加推广视图边框
/// @param promoterView 推广视图
- (void)addPromoterViewMaskLayer:(UIView *)promoterView
{
    //遮罩层
    CAShapeLayer *maskLayer = [CAShapeLayer layer];
    //边框
    CAShapeLayer *borderLayer = [CAShapeLayer layer];
    //高度
    CGFloat height = 55;
    //宽度
    CGFloat width = MAINSCREEN_WIDTH - 15 * 2;
    //箭头高度
    CGFloat arrowHeight = 7;
    //箭头宽度
    CGFloat arrowWidth = 12;
    //圆角
    CGFloat cornerRadius = 6;
    
    UIBezierPath * bezierPath = [UIBezierPath bezierPath];
    //左上角
    [bezierPath moveToPoint:CGPointMake(cornerRadius, arrowHeight)];
    //移动到箭头左侧
    [bezierPath addLineToPoint:CGPointMake(width - 33 - arrowWidth , arrowHeight)];
    //移动到箭头顶端
    [bezierPath addLineToPoint:CGPointMake(width - 33 - arrowWidth/2, 0)];
    //移动到箭头右端
    [bezierPath addLineToPoint:CGPointMake(width - 33, arrowHeight)];
    //右上角
    [bezierPath addLineToPoint:CGPointMake(width - cornerRadius, arrowHeight)];
    //右上角圆
    [bezierPath addArcWithCenter:CGPointMake(width - cornerRadius, arrowHeight + cornerRadius) radius:cornerRadius startAngle:M_PI_2 * 3 endAngle:M_PI_2 * 4 clockwise:YES];
    //右下角
    [bezierPath addLineToPoint:CGPointMake(width, height - cornerRadius)];
    //右下角圆
    [bezierPath addArcWithCenter:CGPointMake(width - cornerRadius, height - cornerRadius) radius:cornerRadius startAngle:0 endAngle:M_PI_2 clockwise:YES];
    //左下角
    [bezierPath addLineToPoint:CGPointMake(cornerRadius, height)];
    //左下角圆
    [bezierPath addArcWithCenter:CGPointMake(cornerRadius, height - cornerRadius) radius:cornerRadius startAngle:M_PI_2 endAngle:M_PI_2 * 2 clockwise:YES];
    //左上角
    [bezierPath addLineToPoint:CGPointMake(0, cornerRadius + arrowHeight)];
    //左上角圆
    [bezierPath addArcWithCenter:CGPointMake(cornerRadius, cornerRadius + arrowHeight) radius:cornerRadius startAngle:M_PI_2 * 2 endAngle:M_PI_2 * 3 clockwise:YES];
    
    borderLayer.path = bezierPath.CGPath;
    borderLayer.lineWidth = 1;
    //边框色
    borderLayer.strokeColor = [[UIColor yyMainThemeColor] colorWithAlphaComponent:0.5].CGColor;
    //填充色
    borderLayer.fillColor = [[UIColor yyMainThemeColor] colorWithAlphaComponent:0.05].CGColor;
    [promoterView.layer addSublayer:borderLayer];
    
    maskLayer.path = bezierPath.CGPath;
    promoterView.layer.mask = maskLayer;
}


- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
