//
//  QGGoodsDetailBannerCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/26.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGGoodsDetailBannerCell.h"
#import "QGBasicUITool.h"
#import "UIImageView+QGWebCache.h"
@interface QGGoodsDetailBannerCell () <UICollectionViewDelegate, UICollectionViewDataSource>

/// 图片展示区域
@property (nonatomic, strong) UICollectionView * collectionView;

/// 页码信息
@property (nonatomic, strong) UILabel * currentPageLabel;

/// 滚动的索引位置
@property (nonatomic, assign) NSInteger currentIndex;
@end

@implementation QGGoodsDetailBannerCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        UICollectionViewFlowLayout *layout = [[UICollectionViewFlowLayout alloc] init];
        layout.scrollDirection = UICollectionViewScrollDirectionHorizontal;
        layout.minimumLineSpacing = 0;
        layout.minimumInteritemSpacing = 0;
        
        //图片展示区域
        self.collectionView = [[UICollectionView alloc] initWithFrame:CGRectZero collectionViewLayout:layout];
        self.collectionView.backgroundColor = [UIColor moduleSeparatorColorF7F7];
        self.collectionView.delegate = self;
        self.collectionView.dataSource = self;
        self.collectionView.pagingEnabled = YES;
        self.collectionView.showsVerticalScrollIndicator = NO;
        self.collectionView.showsHorizontalScrollIndicator = NO;
        [self.contentView addSubview:self.collectionView];
        
        [self.collectionView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(0);
        }];
        
        //注册cell
        [self.collectionView registerClass:[QGGoodsImgCollectionCell class] forCellWithReuseIdentifier:NSStringFromClass([QGGoodsImgCollectionCell class])];
        
        //页码展示背景
        UIView * pageView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor colorWithHexString:@"FFFFFF" alpha:0.6]];
        pageView.layer.cornerRadius = 17/2.0;
        pageView.clipsToBounds = YES;
        [pageView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.right.inset(15);
            make.height.mas_equalTo(17);
            make.bottom.inset(10);
        }];
        
        
        //展示页面
        self.currentPageLabel = [UILabel creatLabelWithSuperView:pageView title:nil titleFontSize:[UIFont qg_regularFontOfSize:10] textColor:[UIColor textColor6666] alignment:NSTextAlignmentCenter];
        [self.currentPageLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.offset(0);
            make.left.right.inset(8);
        }];
        
        
    }
    return self;
}

#pragma mark - UICollectionViewDataSource
- (NSInteger)collectionView:(UICollectionView *)collectionView numberOfItemsInSection:(NSInteger)section
{
    return self.goodsImgArray.count;
}

- (__kindof UICollectionViewCell *)collectionView:(UICollectionView *)collectionView cellForItemAtIndexPath:(NSIndexPath *)indexPath
{
    QGGoodsImgCollectionCell * cell = (QGGoodsImgCollectionCell *)[collectionView dequeueReusableCellWithReuseIdentifier:NSStringFromClass([QGGoodsImgCollectionCell class]) forIndexPath:indexPath];
    [cell.goodsImgView setMallImageByNomalPlaceholderWithURLString:self.goodsImgArray[indexPath.row]];
    return cell;
}

#pragma mak - UICollectionViewDelegate
- (void)collectionView:(UICollectionView *)collectionView didSelectItemAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.clickBlock) {
        self.clickBlock(indexPath.row);
    }
}

- (CGSize)collectionView:(UICollectionView *)collectionView layout:(UICollectionViewLayout*)collectionViewLayout sizeForItemAtIndexPath:(NSIndexPath *)indexPath
{
    return CGSizeMake(self.width, self.height);
}

#pragma mark - UIScrollViewDelegate
- (void)scrollViewDidScroll:(UIScrollView *)scrollView {
    if (scrollView.contentOffset.x < 0) {
        [scrollView setContentOffset:CGPointMake(0, 0)];
    }
    self.currentIndex = (scrollView.contentOffset.x / self.collectionView.width);
}
- (void)setGoodsImgArray:(NSArray<NSString *> *)goodsImgArray
{
    if (_goodsImgArray != goodsImgArray) {
        _goodsImgArray = goodsImgArray;
        self.currentIndex = 0;
        [self.collectionView reloadData];
    }
}

- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

- (void)setCurrentIndex:(NSInteger)currentIndex {
    _currentIndex = currentIndex;

    NSString *currentStr = [NSString stringWithFormat:@"%ld", _currentIndex + 1];
    NSString *allStr = [NSString stringWithFormat:@"%@/%lu", currentStr, (unsigned long) self.goodsImgArray.count];

    if (self.goodsImgArray.count > 0) {
        self.currentPageLabel.text = allStr;
    }
}


@end


@implementation QGGoodsImgCollectionCell

- (instancetype)initWithFrame:(CGRect)frame
{
    if (self = [super initWithFrame:frame]) {
        
        //商品图片
        self.goodsImgView = [UIImageView creatImageViewWithSuperView:self.contentView imageName:nil];
        [self.goodsImgView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.top.bottom.inset(0);
        }];
        
    }
    return self;
}

@end

