//
//  QGMallHeaderItemView.h
//  VirtualPayment
//
//  Created by silicn on 2020/3/11.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import <UIKit/UIKit.h>

#import "QGBaseModel.h"

#define kMaterialItemHeight 92.0f

NS_ASSUME_NONNULL_BEGIN

@interface QGMallMaterialItem :QGBaseModel

/// 标题
@property (nonatomic, copy)NSString *name;
/// 图片链接
@property (nonatomic, copy) NSString *img ;
/// 搜索关键词
@property (nonatomic, copy) NSString *searchTerms;
/// id
@property (nonatomic, copy) NSString *materialId;

@end


typedef void(^QGMallMaterialItemTouchBlock)(QGMallMaterialItem *item);

@interface QGMallMaterialItemCell : UICollectionViewCell
/// 图片
@property (nonatomic, strong) UIImageView *imageView ;
/// 标题
@property (nonatomic, strong) UILabel *textLab ;

@property (nonatomic, strong) QGMallMaterialItem *item;


@end


typedef void(^QGMallMaterialTouchBlock)(QGMallMaterialItem *item);

@interface QGMallMaterialView : UIView

@property (nonatomic, copy) NSArray<QGMallMaterialItem *> *items ;

@property (nonatomic, copy) QGMallMaterialTouchBlock touchBlock;


@end

NS_ASSUME_NONNULL_END
