//
//  QGMallGoodsListViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/3/11.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGMallGoodsListViewController.h"

/// sectionView
#import "QGMallSearchSectionView.h"

#import "QGMallRequestApi.h"

#import "QGMallVerticalGoodsCell.h"
#import "QGMallHorizontalGoodsCell.h"

#import "QGMallHomeGoodsListViewController.h"

@interface QGMallGoodsListViewController ()<UITableViewDelegate,UITableViewDataSource>

@property (nonatomic, strong)UITableView *tableView;

@property (nonatomic, assign)NSInteger orderType;

@property (nonatomic, strong) QGMallSearchSectionView *sectionView;

/// 二级栏目项视图
@property (nonatomic, strong)  QGMallMaterialView *levelTwoMaterialView ;

@end

@implementation QGMallGoodsListViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.dataSource = [NSMutableArray array];
    self.orderType = 1;
    [self _setupNavigation];
    [self _setupMaterialView];
    [self _initNormalUI];
    
    // Do any additional setup after loading the view.
}

/// 设置默认导航
- (void)_setupNavigation
{
    self.title = self.navTitle ? self.navTitle : self.searchTerm;
    [self custemLeftDefaultBarButtonItem];
    [self setNavBarBottomLineHidden:YES];
}

/// 设置MaterialView
/// 小于等于4显示一行,大于4显示两行
- (void)_setupMaterialView
{
    if (self.categoryLevelTwoItmes.count) {
        CGFloat kScreenWidth =[UIScreen mainScreen].bounds.size.width;
        CGFloat height = kMaterialItemHeight * 2;
        if (self.categoryLevelTwoItmes.count <= 4) {
            height  = kMaterialItemHeight ;
        }
        QGMallMaterialView *materialView = [[QGMallMaterialView alloc]initWithFrame:CGRectMake(0, 0, kScreenWidth, height)];
         materialView.items = self.categoryLevelTwoItmes;
        self.tableView.tableHeaderView = materialView;
        self.levelTwoMaterialView = materialView;
        @weakify(self);
        materialView.touchBlock = ^(QGMallMaterialItem * _Nonnull item) {
            @strongify(self);
            [self goToMaterialListWith:item];
        };
    }
}

- (void)reloadMaterialView
{
    if (self.categoryLevelTwoItmes.count) {
        self.levelTwoMaterialView.items = self.categoryLevelTwoItmes;
    }
}

- (void)_initNormalUI
{
    [self.view addSubview:self.tableView];
    
    self.tableView.pageCount = 20;
    self.tableView.pageNum = 1;
    
    [self.tableView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.bottom.equalTo(self.view);
        if (@available(iOS 11.0, *)) {
            make.top.equalTo(self.view.mas_safeAreaLayoutGuideTop);
        } else {
            make.top.equalTo(self.view.mas_top).inset(self.isChildren ? 0:64);
        }
    }];
   
}


/// 网络错误页展示
/// @param pageNum 根据页码区分展示样式
/// @param responseObject 请求成功业务处理失败回调
/// @param error 请求失败错误信息
- (void)networkErrorPageWithPageNum:(NSInteger)pageNum responseObject:(NSDictionary *)responseObject error:(NSError *)error
{
    [self.tableView endRefreshWithBusinessSuccess:NO hasNext:YES];
    //如果是下拉刷新 && 之前没有数据，需要显示网络错误页面
    if (pageNum == 1 && self.dataSource.count == 0) {
        @weakify(self);
        QGDefaultView * view = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
            @strongify(self);
            //开始下拉刷新
            [self.tableView beginRefresh];
        }];
        view.viewType = QGDefaultViewTypeBadNetwork;
    }
    //如果是请求成功业务处理失败，则弹出提示
    else if (responseObject)
    {
        [QGHUDManager showHudWithError:responseObject];
    }
    else if (error)
    {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }
}

#pragma mark - TableView Delegate & DataSource

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.isBox) { /// 网格布局高度
        NSInteger location = indexPath.row * 2;
        if (self.dataSource.count > location) {
            QGMallBaseGoodsModel * goodsModel = self.dataSource[location];
            return goodsModel.verticalCellSize.height;
        }
    }else{
        QGMallBaseGoodsModel * goodsModel = self.dataSource[indexPath.row];
        return goodsModel.horizontalCellHeight;
    }
    return 100;
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    if (self.isBox) {  /// 网格布局Number
        return ceilf(self.dataSource.count/2.0);
    }
    return self.dataSource.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (self.isBox) { /// 网格布局
        QGMallVerticalGoodsCell *cell =  (QGMallVerticalGoodsCell *)[self getCellFromClassName:NSStringFromClass([QGMallVerticalGoodsCell class]) dequeueTableView:tableView];
        NSInteger location = indexPath.row * 2;
        NSInteger length = 2;
        //可能会出现最后一行只有一个的情况
        if (location + length > self.dataSource.count) {
            length = 1;
        }
        cell.goodsList = [self.dataSource subarrayWithRange:NSMakeRange(location, length)];
        @weakify(self);
        cell.clickBlock = ^(QGMallBaseGoodsModel * _Nonnull goodsModel) {
            @strongify(self);
            [self goToGoodsDetail:goodsModel];
        };
        return cell;
    }
    /// 列表布局
    QGMallHorizontalGoodsCell * cell = (QGMallHorizontalGoodsCell *)[self getCellFromClassName:NSStringFromClass([QGMallHorizontalGoodsCell class]) dequeueTableView:tableView];
    cell.goodsModel = self.dataSource[indexPath.row];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    if (!self.isBox) {
        QGMallBaseGoodsModel *model = self.dataSource[indexPath.row];
        [self goToGoodsDetail:model];
    }
}



#pragma mark - 自定义点击事件


/// 点击综合,券后价,销量等时间
/// @param index 点击的位置
/// @param sortType 排序类型
- (void)reloadDataSortWithIndex:(NSInteger)index sortType:(QGMallSearchSectionSortType)sortType
{
    if (index == 0) {
        self.orderType = 1; /// 综合排序
    }else if (index == 1){
        if (sortType == QGMallSearchSectionSortTypeAscending) {
            self.orderType = 2; // 券后价升序
        }else if (sortType == QGMallSearchSectionSortTypeDescending){
            self.orderType = 3; // 券后价降序
        }
    }else if (index == 2){
        if (sortType == QGMallSearchSectionSortTypeAscending) {
            self.orderType = 4; // 销量升序
        }else if (sortType == QGMallSearchSectionSortTypeDescending){
            self.orderType = 5; // 销量降序
        }
    }
    [self.tableView setContentOffset:CGPointMake(0, 0)];
    [self.tableView beginRefresh];
}



/// 去二级商品页面
/// @param item QGMallMaterialItem
- (void)goToMaterialListWith:(QGMallMaterialItem *)item
{
    QGMallHomeGoodsListViewController *listVC = [[QGMallHomeGoodsListViewController alloc]init];
    listVC.searchTerm = item.searchTerms;
    listVC.materialId = item.materialId;
    listVC.navTitle = item.name;
    listVC.isBox = NO;
    /// 标记二级子类,用于埋点
    listVC.isLevelTwo = YES;
    listVC.levelOneName = self.searchTerm;
    [self.navigationController pushViewController:listVC animated:YES];
    
    QGAppCoreModelClickEvent *event = [QGAppCoreModelClickEvent acmcEventWithPage:self.searchTerm path:@"二级类目" name:item.name detail_name:nil acmc_model_other:nil];
    [QGAnalyticsService analyticsTrackWithEvent:event];
    
}

/// 去商品详情页
- (void)goToGoodsDetail:(QGMallBaseGoodsModel *)goodsModel
{
    [Mediator performTarget:ClassNameWithHeadType(QGHeaderTypeQGMallGoodsDetailViewController) parameters:@{@"goodsId":goodsModel.goodsId} handlerBlock:nil];
}

#pragma mark - 属性初始化

- (UITableView *)tableView
{
    if (_tableView == nil) {
        _tableView = [[UITableView alloc]initWithFrame:CGRectZero style:UITableViewStylePlain];
        _tableView.delegate = self;
        _tableView.dataSource = self;
        _tableView.estimatedRowHeight = 0;
        _tableView.estimatedSectionFooterHeight = 0;
        _tableView.estimatedSectionHeaderHeight = 0;
        _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        _tableView.rowHeight = UITableViewAutomaticDimension;
    }
    return _tableView;
}

- (QGMallSearchSectionView *)sectionView
{
    if (_sectionView == nil) {
        /// 顶部分组
        _sectionView = [[QGMallSearchSectionView alloc]init];
        _sectionView.isBox = self.isBox;
        @weakify(self);
        /// 触发布局改变
        _sectionView.cellLayoutBlock = ^(BOOL isBox) {
              @strongify(self);
              self.isBox = !self.isBox;
              [self.tableView reloadData];
        };
        /// 点击综合,券后价,销量等时间
        _sectionView.touchItemBlock = ^(NSInteger index, QGMallSearchSectionSortType type) {
              @strongify(self);
              [self reloadDataSortWithIndex:index sortType:type];
        };
    }
    return _sectionView;
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
