//
//  QGTaoBaoAuthView.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/28.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGAuthAlertView.h"
#import "QGBasicUITool.h"
#import "QGGradientShadowButton.h"
@implementation QGAuthAlertView

- (instancetype)initWithType:(QGAuthAlertViewType)authType
{
    if (self = [super init]) {
        
        self.popType = PopViewTypeAlert;
        
        NSString * titleStr;
        NSString * imageStr;
        switch (authType) {
            case QGAuthAlertViewTypeTaoBao:
                {
                    titleStr = @"请完成淘宝授权";
                    imageStr = @"mall_auth_tb";
                }
                break;
            case QGAuthAlertViewTypeJD:
                {
                    titleStr = @"请完成京东授权";
                    imageStr = @"mall_auth_jd";
                }
            break;
            case QGAuthAlertViewTypePDD:
                {
                    titleStr = @"请完成拼多多授权";
                    imageStr = @"mall_auth_pdd";
                }
            break;
            case QGAuthAlertViewTypeSN:
                {
                    titleStr = @"请完成苏宁授权";
                    imageStr = @"mall_auth_sn";
                }
            break;
                
            default:
                break;
        }
        
        
        //图片地址
        UIImageView * iconImg = [UIImageView creatImageViewWithSuperView:self.contentView imageName:imageStr];
        [iconImg mas_makeConstraints:^(MASConstraintMaker *make) {
            make.centerX.offset(0);
            make.size.mas_equalTo(CGSizeMake(68, 68));
            make.top.offset(32);
        }];
        
        //授权文案
        UILabel * titleLabel = [UILabel creatLabelWithSuperView:self.contentView title:titleStr titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentCenter];
        [titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(10);
            make.top.mas_equalTo(iconImg.mas_bottom).offset(18);
            make.height.mas_equalTo(25);
        }];
        
        //详情描述
        UILabel * descLabel = [UILabel creatLabelWithSuperView:self.contentView title:@"授权后可享受省钱购买" titleFontSize:[UIFont qg_lightFontOfSize:14] textColor:[UIColor textColor9999] alignment:NSTextAlignmentCenter];
        [descLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(10);
            make.top.mas_equalTo(titleLabel.mas_bottom).offset(6);
            make.height.mas_equalTo(20);
        }];
        
        //授权按钮
        QGGradientShadowButton * authButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:@"去授权" textFont:[UIFont qg_regularFontOfSize:17]];
        
        [authButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.mas_equalTo(descLabel.mas_bottom).offset(40);
            make.height.mas_equalTo(40);
            make.left.right.inset(35);
            make.bottom.inset(25);
        }];
        
        [authButton addTarget:self action:@selector(authButtonClick) forControlEvents:UIControlEventTouchUpInside];
        
    }
    return self;
}


- (void)authButtonClick
{
    if (self.authBlock) {
        self.authBlock();
    }
    [self dismissView:nil];
}

@end
