//
//  QGBaiChuanWebViewController.m
//  VirtualPayment
//
//  Created by silicn on 2020/2/28.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBaiChuanWebViewController.h"
#import "NSString+QGURLParam.h"
#import "QGMallRequestApi.h"
#import "QGBaiChuanManager.h"
#import "QGAlertView.h"
#import "QGAnalyticsService.h"


@interface QGBaiChuanWebViewController ()

@end

@implementation QGBaiChuanWebViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = @"加载中...";
    // Do any additional setup after loading the view.
}

-(void)setOpenUrl:(NSString *)openUrl {
    _openUrl = openUrl;
    self.urlString = openUrl;
}

#pragma mark - UITableViewDelegate
- (BOOL)webView:(UIWebView *)webView shouldStartLoadWithRequest:(NSURLRequest *)request navigationType:(UIWebViewNavigationType)navigationType {
    
    /// 在联盟的授权回调中截取回调地址,
    /// 1,如果能截取到,App主动查询授权结果
    /// 2,如果不能截取到,或者参数不全,走h5页面获取结果.
    if ([request.URL.path isEqualToString:kBaiChuanAuthResultIdentification]) {
        NSString *url = request.URL.absoluteString;
        NSMutableDictionary *dic = [url getURLParameters];
        /// 参数全部获取,必须包含code和ttid才能请求结果
        if (dic[@"code"] && dic[@"ttid"]) {
            [self requestResultWithParams:dic];
            return NO;
        }
    }
     return  [super webView:webView shouldStartLoadWithRequest:request navigationType:navigationType];
}


/// 本地淘宝联盟授权结果获取结果
/// @param dic 参数包括code和ttid 均是淘宝自己拼接上的
- (void)requestResultWithParams:(NSDictionary *)dic
{
    [QGHUDManager showHud:nil];
    QGTalosNetwork *networking = [QGTalosNetwork shareManager];
    NSMutableDictionary *param = [NSMutableDictionary dictionaryWithDictionary:dic];
    if (QGUserInfo.sharedUserInfo.isLogin) {
        [param setObject:QGUserInfo.sharedUserInfo.uuid forKey:@"uuid"];
    }
    [networking POST:[QGMallRequestApi urlWithIndex:QGMallRequestServerMethodAuthResult] parameters:param success:^(id  _Nonnull responseObject) {
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            [QGHUDManager showHud:@"授权成功"];
            QGUserInfo.sharedUserInfo.alimamaAuth = YES;
            [[NSNotificationCenter defaultCenter] postNotificationName:AlimamaAuthSuccessNotification object:nil];
            [self.navigationController popViewControllerAnimated:YES];
            [self analyticsWithSuccess:YES message:nil];
        }else{
            [QGHUDManager hideHud];
            NSString *message = responseObject[@"msg"] ? responseObject[@"msg"] :@"未知原因,授权失败";
            @weakify(self);
            QGAlertView *alert = [[QGAlertView alloc]initWithTitle:@"授权失败" message:message cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:^(NSInteger index) {
                @strongify(self);
                QGUserInfo.sharedUserInfo.alimamaAuth = NO;
                [QGBaiChuanManager.shareInstance unAuthLogin];
                [self.navigationController popViewControllerAnimated:YES];
            }];
            [alert showInView:nil];
             [self analyticsWithSuccess:NO message:message];
        }
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager hideHud];
         @weakify(self);
         QGAlertView *alert = [[QGAlertView alloc]initWithTitle:@"授权失败" message:@"网络错误,授权失败" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:^(NSInteger index) {
            @strongify(self);
            QGUserInfo.sharedUserInfo.alimamaAuth = NO;
            [QGBaiChuanManager.shareInstance unAuthLogin];
            [self.navigationController popViewControllerAnimated:YES];
       }];
       [alert showInView:nil];
    }];
}


/// 授权结果埋点统计
/// @param success 授权成功与否success|failed
/// @param msg success ? @"授权成功":msg
- (void)analyticsWithSuccess:(BOOL)success message:(NSString *)msg
{
    NSString *value = success ? @"success":@"failed";
    if (success) {
        msg = @"授权成功";
    }
    NSString *phone;
    if (QGUserInfo.sharedUserInfo.isLogin) {
        phone = QGUserInfo.sharedUserInfo.userName;
    }
    QGAppBusinessStateEvent *event = [QGAppBusinessStateEvent abseEventWithPage:@"淘宝联盟授权" action:@"淘宝联盟授权结果" value:value code:nil desc:msg phone:phone];
    [QGAnalyticsService analyticsTrackWithEvent:event];
}


- (void)dealloc
{
    /// 解除授权 : 百川授权成功,但是没做联盟授权,无意义.所以解除授权
        if (![QGBaiChuanManager isAliMamaAuthed] && [QGBaiChuanManager isTaoBaoAuthed]) {
            [[QGBaiChuanManager shareInstance] unAuthLogin];
        }
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
