//
//  QGPrivacyProtocolController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/11/19.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGPrivacyProtocolController.h"
#import "QGGradientShadowButton.h"
#import "QGWindowManager.h"
#import "QGAlertView.h"
#import "AFNetworking.h"

@interface QGPrivacyProtocolController ()

@end

@implementation QGPrivacyProtocolController

- (void)dealloc
{
    [self removeNotification];
}

- (void)addNotification
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(networkChange:) name:AFNetworkingReachabilityDidChangeNotification object:nil];
}

- (void)removeNotification
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:AFNetworkingReachabilityDidChangeNotification object:nil];
}

- (void)networkChange:(NSNotification *)notification
{
    AFNetworkReachabilityStatus status = [notification.userInfo[AFNetworkingReachabilityNotificationStatusItem] integerValue];
    if (status == AFNetworkReachabilityStatusReachableViaWiFi || status == AFNetworkReachabilityStatusReachableViaWWAN) {
        [self.myWebView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:self.urlString]]];
    }
}



- (void)viewDidLoad {
    
    self.myWebView = [[UIWebView alloc] init];
    self.myWebView.delegate = self;
    self.myWebView.backgroundColor = [UIColor whiteColor];
    self.urlString = VCCPrivacyAgreement;
    
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self.view addSubview:self.myWebView];
    [self addNotification];
    
    //底部视图
    UIView * bottomView = [UIView creatViewWithSuperView:self.view backgroundColor:[UIColor whiteColor]];
    [bottomView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(0);
        make.bottom.inset([DeviceAdaptation getBottomSafeAreaHeight]);
        make.height.mas_equalTo(70);
    }];
    
    
    //不同意按钮
    UIButton * disagressButton = [UIButton creatButtonWithSuperView:bottomView title:@"不同意" titleFont:[UIFont qg_regularFontOfSize:17] textColor:[UIColor yyMainThemeColor]];
    [disagressButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.offset(20);
        make.height.mas_equalTo(40);
        make.centerY.offset(0);
    }];
    [disagressButton addTarget:self action:@selector(disagressButtonClick) forControlEvents:UIControlEventTouchUpInside];
    
    
    //同意按钮
    QGGradientShadowButton * agreeButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:bottomView title:@"同意" textFont:[UIFont qg_regularFontOfSize:17]];
    [agreeButton mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(disagressButton.mas_right).offset(40);
        make.width.mas_equalTo(disagressButton);
        make.right.inset(20);
        make.height.mas_equalTo(40);
        make.centerY.offset(0);
    }];
    
    //同意协议
    [agreeButton touchUpInsideBlock:^(UIButton * _Nonnull button) {
        [[QGWindowManager shareInstance] dismissPrivacyProtocolWindowAnimated:YES];
    }];
    
    CGFloat navStatusHeight = [DeviceAdaptation getNavBarAndStatusBarHeight];
    [self.myWebView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.right.inset(0);
        make.top.offset(160 + navStatusHeight);
        make.bottom.mas_equalTo(bottomView.mas_top).offset(0);
    }];
    
    //协议背景图
    UIImageView * bgImgView = [UIImageView creatImageViewWithSuperView:self.view imageName:@"privacy_protocol_bg"];
    [bgImgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.mas_equalTo(self.myWebView.mas_top).offset(-32);
        make.size.mas_equalTo(CGSizeMake(179, 115));
        make.centerX.offset(0);
    }];
    
    //延时0.5S
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        ///展示权限许可协议
        [self permissionAlert];
    });
    
}


///权限调用说明
- (void)permissionAlert
{
    /*
    QGAlertTextView * alertView = [[QGAlertTextView alloc] initWithTitle:@"权限调用说明" message:@"当您登录真享生活时，我们会：\n1.获取允许访问相册、图库：用于上传图片（设置头像、用户反馈、在线客服）调起等功能。\n2.获取相机权限、照片、媒体内容及文件：用于人脸识别、设置头像、用户反馈、在线客服等功能。\n3.获取麦克风权限：用于语音唤醒、语音搜索、人脸识别、音频key安全认证功能。\n在使用真享生活过程中，还将可能使用其他权限，详见真享生活隐私政策。" cancelButtonTitle:nil sureButtonTitle:@"我知道了" clickBlock:^(NSInteger index) {
        
    }];
    alertView.messageTextView.textColor = [UIColor textColor3333];
    [alertView showInView:self.view];
    */
    
    QGAlertView * alertView = [[QGAlertView alloc] initWithTitle:@"权限调用说明" message:@"当您登录真享生活时，我们会：\n1.获取允许访问相册、图库：用于上传图片（设置头像、用户反馈、在线客服）调起等功能。\n2.获取相机权限、照片、媒体内容及文件：用于人脸识别、设置头像、用户反馈、在线客服等功能。\n3.获取麦克风权限：用于语音唤醒、语音搜索、人脸识别、音频key安全认证功能。\n4.获取位置信息：用于向您推荐附近的服务。\n在使用真享生活过程中，还将可能使用其他权限，详见真享生活隐私政策。" cancelButtonTitle:nil sureButtonTitle:@"我知道了" clickBlock:^(NSInteger index) {
        
    }];
    alertView.titleLabel.font = [UIFont qg_mediumFontOfSize:16];
    alertView.messageLabel.textAlignment = NSTextAlignmentLeft;
    alertView.messageLabel.textColor = [UIColor textColor3333];
    [alertView showInView:self.view];
}


/// 不同意按钮点击事件
- (void)disagressButtonClick
{
    QGAlertView * alertView = [[QGAlertView alloc] initWithTitle:@"温馨提示" message:@"真享生活非常重视对您个人信息的保护，将严格按照《真享生活隐私政策》向您提供服务，请您仔细阅读以便了解我们对您个人信息的处理规则及权限申请目的。如您不同意本隐私政策，很遗憾我们将无法为您提供服务。" cancelButtonTitle:nil sureButtonTitle:@"我再想想" clickBlock:^(NSInteger index) {
        
    }];
    alertView.titleLabel.font = [UIFont qg_mediumFontOfSize:16];
    alertView.messageLabel.textAlignment = NSTextAlignmentLeft;
    alertView.messageLabel.textColor = [UIColor textColor3333];
    [alertView showInView:self.view];
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
