//
//  QGGuideViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2019/6/27.
//  Copyright © 2019 bo.zhang. All rights reserved.
//

#import "QGGuideViewController.h"
#import "QGWindowManager.h"
#import "QGBasicUITool.h"
@interface QGGuideViewController ()<UIScrollViewDelegate>

@property (nonatomic, strong) UIScrollView *scrollView;

@property (nonatomic, strong) UIPageControl *pageControl;

@end

@implementation QGGuideViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    //加载新用户指导页面
    [self initGuide];
}

- (void)initGuide{
    
    //创建滑动页面和指示器
    self.scrollView = [[UIScrollView alloc] initWithFrame:self.view.bounds];
    [self.scrollView setContentSize:CGSizeMake([UIScreen mainScreen].bounds.size.width * 4, UIScreen.mainScreen.bounds.size.height)];
    [self.scrollView setPagingEnabled:YES];  //视图整页显示
    [self.scrollView setShowsHorizontalScrollIndicator:NO];//隐藏下面的滚动条
    self.scrollView.delegate = self;
    [self.view addSubview:self.scrollView];
    
    [self.scrollView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.equalTo(self.view);
    }];
    
    
    //跳过
    UIButton *skipBtn = [UIView creatButtonWithSuperView:self.view title:@"跳过" titleFont:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor9999]];
    [skipBtn.layer setCornerRadius:14.f];
    [skipBtn.layer setMasksToBounds:YES];
    [skipBtn.layer setBorderWidth:1.f];
    [skipBtn.layer setBorderColor:[UIColor textColor9999].CGColor];
    [skipBtn addTarget:self action:@selector(enterButtonClick) forControlEvents:UIControlEventTouchDown];
    
    CGFloat navStatusHeight = [DeviceAdaptation getStatusBarHeight];
    [skipBtn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.mas_equalTo(self.view.mas_right).offset(-28);
        make.top.mas_equalTo(self.view.mas_top).offset(navStatusHeight + 20);
        make.width.equalTo(@(50));
    }];
    
    
    self.pageControl=[[UIPageControl alloc]init];
    [self.view addSubview:self.pageControl];
    self.pageControl.numberOfPages=4;
    self.pageControl.currentPageIndicatorTintColor=[UIColor colorWithHexString:@"FF2828"];
    self.pageControl.pageIndicatorTintColor=[UIColor lightGrayColor];
    [self.pageControl mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(self.view.bounds.size.width);
        make.height.mas_equalTo(5);
        make.bottom.mas_equalTo(self.view.mas_bottom).inset(25/812.0 * MAINSCREEN_HEIGHT);
    }];
    
    
    //第一页面
    UIView *view1 = [UIView creatViewWithSuperView:_scrollView backgroundColor:[UIColor colorWithHexString:@"#F5414A"]];
    [view1 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.mas_equalTo(self.scrollView);
        make.width.mas_equalTo([UIScreen mainScreen].bounds.size.width);
        make.height.mas_equalTo([UIScreen mainScreen].bounds.size.height);
    }];

    UIImageView *imageView1 = [UIImageView creatImageViewWithSuperView:view1 imageName:@"page_1_image"];
    imageView1.contentMode = UIViewContentModeScaleAspectFit;
    [imageView1 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.inset(10);
        make.centerY.equalTo(view1);
    }];
    
    UILabel *subTitleLab1 = [UILabel creatLabelWithSuperView:view1 title:@"精打细算  购物生活两不误" titleFontSize:[UIFont qg_regularFontOfSize:14.0f] textColor:UIColor.whiteColor alignment:NSTextAlignmentLeft];
        [subTitleLab1 mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.inset(30);
            make.bottom.equalTo(imageView1.mas_top).offset(-8);
        }];
    
    /// 文字
      UILabel *titleLab1 = [UILabel creatLabelWithSuperView:view1 title:@"真享生活 品牌升级 \n全新功能" titleFontSize:[UIFont qg_mediumFontOfSize:30.0f] textColor:UIColor.whiteColor alignment:NSTextAlignmentLeft];
      titleLab1.numberOfLines = 0;
      [titleLab1 mas_makeConstraints:^(MASConstraintMaker *make) {
          make.left.inset(30);
          make.bottom.equalTo(subTitleLab1.mas_top).offset(-8);
      }];


    //第二页面
    UIView *view2 = [UIView creatViewWithSuperView:_scrollView backgroundColor:[UIColor whiteColor]];
    [view2 mas_makeConstraints:^(MASConstraintMaker *make) {
          make.top.mas_equalTo(self.scrollView);
          make.left.equalTo(view1.mas_right);
          make.width.mas_equalTo([UIScreen mainScreen].bounds.size.width);
          make.height.mas_equalTo([UIScreen mainScreen].bounds.size.height);
    }];

    UIImageView *backImageView2 = [UIImageView creatImageViewWithSuperView:view2 imageName:@"page_back"];
    backImageView2.contentMode = UIViewContentModeScaleToFill;
    [backImageView2 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.equalTo(view2);
        make.height.mas_equalTo(678/812.0 *MAINSCREEN_HEIGHT);
    }];

    //图片与标题
    UIImageView *imageView2 = [UIImageView creatImageViewWithSuperView:backImageView2 imageName:@"page_2_image"];
    imageView2.contentMode = UIViewContentModeScaleAspectFit;
    [imageView2 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.centerY.equalTo(backImageView2);
        make.left.right.lessThanOrEqualTo(backImageView2).inset(20);
        make.width.equalTo(imageView2.mas_height).multipliedBy(676/768.0);
    }];

    UILabel *titleLab2 = [UILabel creatLabelWithSuperView:backImageView2 title:@"海量优惠券 购物有返现" titleFontSize:[UIFont qg_mediumFontOfSize:25.0f] textColor:[UIColor colorWithHexString:@"FF2828"] alignment:NSTextAlignmentCenter];
    [titleLab2 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(backImageView2);
        make.bottom.inset(81/812.0 *MAINSCREEN_HEIGHT);
    }];

    UILabel *subTitleLab2 = [UILabel creatLabelWithSuperView:backImageView2 title:@"淘宝、天猫专属优惠 单单有返现" titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentCenter];

    [subTitleLab2 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(titleLab2);
        make.bottom.inset(54/812.0 *MAINSCREEN_HEIGHT);
    }];

    //第三个页面
    UIView *view3 = [UIView creatViewWithSuperView:_scrollView backgroundColor:[UIColor whiteColor]];
    [view3 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.mas_equalTo(self.scrollView);
        make.left.equalTo(view2.mas_right);
        make.width.mas_equalTo([UIScreen mainScreen].bounds.size.width);
        make.height.mas_equalTo([UIScreen mainScreen].bounds.size.height);
    }];

    UIImageView *backImageView3 = [UIImageView creatImageViewWithSuperView:view3 imageName:@"page_back"];
       backImageView3.contentMode = UIViewContentModeScaleToFill;
       [backImageView3 mas_makeConstraints:^(MASConstraintMaker *make) {
           make.top.left.right.equalTo(view3);
           make.height.mas_equalTo(678/812.0 *MAINSCREEN_HEIGHT);
       }];


    //图片与标题
    UIImageView *imageView3 = [UIImageView creatImageViewWithSuperView:backImageView3 imageName:@"page_3_image"];
    imageView3.contentMode = UIViewContentModeScaleAspectFit;
    [imageView3 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.centerX.equalTo(backImageView3);
        make.left.right.lessThanOrEqualTo(backImageView3).inset(20);
        make.width.equalTo(imageView3.mas_height).multipliedBy(676/768.0);
    }];


    UILabel *titleLab3 = [UILabel creatLabelWithSuperView:backImageView3 title:@"成为推广官 独享更多特权" titleFontSize:[UIFont qg_mediumFontOfSize:25.0f] textColor:[UIColor colorWithHexString:@"FF2828"] alignment:NSTextAlignmentCenter];
    [titleLab3 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(backImageView3);
        make.bottom.inset(81/812.0 *MAINSCREEN_HEIGHT);
    }];

    UILabel *subTitleLab3 = [UILabel creatLabelWithSuperView:backImageView3 title:@"邀请好友 有钱大家赚" titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentCenter];

    [subTitleLab3 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(titleLab3);
        make.bottom.inset(54/812.0 *MAINSCREEN_HEIGHT);
    }];

    /// 第四个页面
    UIView *view4 = [UIView creatViewWithSuperView:_scrollView backgroundColor:[UIColor whiteColor]];
       [view4 mas_makeConstraints:^(MASConstraintMaker *make) {
           make.top.mas_equalTo(self.scrollView);
           make.left.equalTo(view3.mas_right);
           make.width.mas_equalTo([UIScreen mainScreen].bounds.size.width);
           make.height.mas_equalTo([UIScreen mainScreen].bounds.size.height);
       }];

    UIImageView *backImageView4 = [UIImageView creatImageViewWithSuperView:view4 imageName:@"page_back"];
    backImageView4.contentMode = UIViewContentModeScaleToFill;
    [backImageView4 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.right.equalTo(view4);
        make.height.mas_equalTo(678/812.0 *MAINSCREEN_HEIGHT);
    }];


    //图片与标题
    UIImageView *imageView4 = [UIImageView creatImageViewWithSuperView:backImageView4 imageName:@"page_4_image"];
    imageView4.contentMode = UIViewContentModeScaleAspectFit;
    [imageView4 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.centerX.equalTo(backImageView4);
        make.left.right.lessThanOrEqualTo(backImageView4).inset(20);
        make.width.equalTo(imageView4.mas_height).multipliedBy(676/768.0);
    }];


    UILabel *titleLab4 = [UILabel creatLabelWithSuperView:backImageView4 title:@"全新享花卡 储蓄账户" titleFontSize:[UIFont qg_mediumFontOfSize:25.0f] textColor:[UIColor colorWithHexString:@"FF2828"] alignment:NSTextAlignmentCenter];
    [titleLab4 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(backImageView4);
        make.bottom.inset(81/812.0 *MAINSCREEN_HEIGHT);
    }];

    UILabel *subTitleLab4 = [UILabel creatLabelWithSuperView:backImageView4 title:@"全场景消费享返现" titleFontSize:[UIFont qg_lightFontOfSize:14.0f] textColor:UIColor.textColor9999 alignment:NSTextAlignmentCenter];

    [subTitleLab4 mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerX.equalTo(titleLab4);
        make.bottom.inset(54/812.0 *MAINSCREEN_HEIGHT);
    }];


    //立即体验按钮
    UIButton *btn = [UIButton creatButtonWithSuperView:view4 title:@"立即体验" titleFont:[UIFont qg_regularFontOfSize:17.f] textColor:[UIColor colorWithHexString:@"FF594A"]];
    [btn.layer setCornerRadius:16.f];
    [btn.layer setMasksToBounds:YES];
    [btn.layer setBorderWidth:1.f];
    [btn.layer setBorderColor:[UIColor colorWithHexString:@"FC2C27"].CGColor];
    [btn addTarget:self action:@selector(enterButtonClick) forControlEvents:UIControlEventTouchDown];
    [btn mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.inset(65/812.0 * MAINSCREEN_HEIGHT);
        make.centerX.mas_equalTo(view4.mas_centerX);
        make.width.mas_equalTo(119);
        make.height.mas_equalTo(32);
    }];
    
    
    
    
    
}

-(void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    self.pageControl.currentPage=(int)(self.scrollView.contentOffset.x/self.view.bounds.size.width);
}

/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/



- (void)enterButtonClick
{
    [[QGWindowManager shareInstance] dismissGuideWindowAnimated:YES];
}

@end
