//
//  QGDefaultLaunchViewController.m
//  VirtualPayment
//
//  Created by 张博 on 2020/2/14.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGDefaultLaunchViewController.h"

#import "SystemManager.h"
#import "QGDefaultView.h"

@interface QGDefaultLaunchViewController ()

/// 请求的次数
/// 第一次请求超时时间设为5s，后面为30s
@property (nonatomic, assign) NSInteger requestCount;

@end

@implementation QGDefaultLaunchViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    
    //初始化闪屏页
    UIImageView * launchImgView = [UIImageView creatImageViewWithSuperView:self.view imageName:@"launch_screen_image"];
    [launchImgView mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.inset(120 + [DeviceAdaptation getBottomSafeAreaHeight]);
        make.centerX.offset(0);
        make.size.mas_equalTo(CGSizeMake(189, 62));
    }];
    
    
    //登录状态
    if ([QGUserInfo sharedUserInfo].isLogin) {
        //初始化数据
        self.requestCount = 1;
        //刷新token
        [self refreshToken];
    }
    //非登录状态，直接出去，该干嘛干嘛去
    else
    {
        if (self.continueBlock) {
            self.continueBlock();
        }
    }
}


- (void)refreshToken
{
    //检测网络状态，如果网络不可达，则直接提示用户
    BOOL network = [[QGTalosNetwork shareManager] checkNetworkStatus];
    //如果不可用，则弹出网络断开的提示
    if (!network) {
        QGDefaultView * badNetworkView = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
            NSURL *url = [NSURL URLWithString:UIApplicationOpenSettingsURLString];
            if([[UIApplication sharedApplication]canOpenURL:url]) {
                if (@available(iOS 10.0, *)) {
                    [[UIApplication sharedApplication] openURL:url options:@{} completionHandler:nil];
                } else {
                    [[UIApplication sharedApplication] openURL:url];
                }
            }
        }];
        //此时提示缺省页
        badNetworkView.viewType = QGDefaultViewTypeNormal;
        [badNetworkView setIconImageWithImageName:@"bad_network" messageTitle:@"您的网络已断开连接，请检查网络设置" buttonTitle:@"设置"];
        badNetworkView.reloadButton.hidden = NO;
        return;
    }
    
    
    //第一次请求超时时间为5s
    NSTimeInterval timeoutInterval = self.requestCount == 1 ? 5 : 30;
    if (self.requestCount > 1) {
        [QGHUDManager showHud:nil];
    }
    @weakify(self);
//    [[SystemManager shareInstance] refreshTokenWithTimeoutInterval:timeoutInterval Success:^(BOOL isSuccess, NSString *token) {
//        @strongify(self);
//        //隐藏loading
//        if (self.requestCount > 1) {
//            [QGHUDManager hideHud];
//        }
//        //请求成功，并且是0000
//        //皆大欢喜，直接执行成功回调，正常显示页面
//        if (isSuccess) {
//            if (self.continueBlock) {
//                self.continueBlock();
//            }
//        }
//        else
//        {
//            [self refreshTokenRequestFail];
//        }
//    } failure:^(NSError *error) {
//        @strongify(self);
//        //隐藏loading
//        if (self.requestCount > 1) {
//            [QGHUDManager hideHud];
//        }
//        
//        [self refreshTokenRequestFail];
//    }];
}

///没有获取到token
- (void)refreshTokenRequestFail
{
    //尝试只有三次机会
    //超过三次后，清空登录状态
    if (self.requestCount >= 3) {
        [QGUserInfo logOut];
        //干掉当前页面，继续接下来的操作
        if (self.continueBlock) {
            self.continueBlock();
        }
    }
    //没有超出三次，则展示刷新页面
    else
    {
        //累计请求次数
        self.requestCount = self.requestCount + 1;
        
        @weakify(self);
        QGDefaultView * badNetworkView = [QGDefaultView defaultViewShowWithSuperView:self.view reloadBlock:^{
            @strongify(self);
            //刷新token
            [self refreshToken];
        }];
        badNetworkView.viewType = QGDefaultViewTypeBadNetwork;
        badNetworkView.messageLabel.text = @"网络像蜗牛一样慢，请刷新重试";
    }
}



/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
