//
//  QGLoginRequestApi.h
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/24.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface QGLoginRequestApi : NSObject
///登录注册模块请求方法枚举
typedef NS_ENUM(NSInteger, QGLoginRequestServerMethod) {
    ///1.登录
    QGLoginRequestServerMethodLogin = 1,
    ///2.发送短信验证码
    QGLoginRequestServerMethodRegisterSendSms,
    ///3.登录检验短信验证码
    QGLoginRequestServerMethodLoginCheckSms,
    ///4.修改密码校验验证码
    QGLoginRequestServerMethodResetPasswordCheckSms,
    ///5.设置新密码短信
    QGLoginRequestServerMethodSetNewPasswordCode,
    ///7.刷新token
    QGLoginRequestServerMethodAuthRefreshToken,
    ///8.获取图形验证码
    QGLoginRequestServerMethodSmsCaptcha,
    ///9发送验证码的验证类型
    QGLoginRequestServerMethodSmsCaptchaType,
    ///微信登录绑定校验
    QGLoginRequestServerMethodCheckWechatBinding,
    ///微信绑定手机号登陆
    QGLoginRequestServerMethodLoginWechat,
    ///apple登录绑定校验
    QGLoginRequestServerMethodCheckAppleBinding,
    ///apple绑定手机号登陆
    QGLoginRequestServerMethodLoginApple,
    ///获取微信,Apple,百川授权状态
    QGLoginRequestServerMethodQueryStatus,
    /// 根据unionId查询是否可以绑定
    QGLoginRequestServerMethodBindAvailable,
    /// 解绑微信
    QGLoginRequestServerMethodUnBindWeChat,
    /// 设置页面绑定微信获取验证码
    QGLoginRequestServerMethodWxVerifyGetCode
};

/*!
 根据接口名返回URL
 */
+(NSString*)urlWithQGLoginRequestServerMethod:(QGLoginRequestServerMethod)method;

@end
