//
//  QGSucceedRetrieceSetNewPasswordViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/20.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGSucceedRetrieceSetNewPasswordViewController.h"
#import "QGBasicUITool.h"
#import "QGPasswordInputWithTitleCell.h"
#import "QGLoginBottomBtnTableViewCell.h"
#import "QGAlertView.h"
#import "QGLoginRequestApi.h"
@interface QGSucceedRetrieceSetNewPasswordViewController ()
///自定义tableView header
@property (nonatomic, strong)UIView *tableHeaderView;
///第一次输入的密码
@property (nonatomic, copy)NSString *firstPassword;
///第二次输入的密码
@property (nonatomic, copy)NSString *secondPassword;
///第二个密码输入框
@property (nonatomic, strong)QGPasswordInputWithTitleCell *secondCell;
///下一步按钮，方便修改状态
@property (nonatomic, strong)QGGradientShadowButton *loginButton;
///手机号
@property (nonatomic, copy)NSString *phoneNumberStr;
/// 临时token只做修改密码使用
@property (nonatomic, copy)NSString *token;

@end

@implementation QGSucceedRetrieceSetNewPasswordViewController

- (void)viewDidLoad {
    [super viewDidLoad];

    self.title = @"找回登录密码";
    
    //创建header
    UILabel *titleLable = [UILabel creatLabelWithSuperView:self.tableHeaderView title:@"短信验证成功，请设置新登录密码" titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];

    [titleLable mas_makeConstraints:^(MASConstraintMaker *make) {
        make.topMargin.mas_equalTo(20);
        make.left.right.equalTo(self.tableHeaderView).inset(20);
        make.height.mas_equalTo(25);
    }];
    self.tableView.tableHeaderView = self.tableHeaderView;
}

#pragma mark --request
//设置密码的网络请求
-(void)setPassword
{
    [self.view endEditing:YES];
    
    
    if (![self.firstPassword isEqualToString:self.secondPassword]) {
        self.secondCell.titleColor = [UIColor textColorF41C1C];
        self.secondCell.celltitle = @"密码不一致";
        return;
    }
    
    if (!self.firstPassword.isValidPasswordString) {
        [QGHUDManager showHud:@"密码格式不正确"];
        return;
    }
    
    NSMutableDictionary *parame = [[NSMutableDictionary alloc]init];
    [parame setObject:self.firstPassword forKey:@"password"];
    [parame setObject:self.token forKey:@"verifySmsCodeToken"];
    [parame setObject:self.phoneNumberStr forKey:@"phone"];
    
    //短验
    NSString * url = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodSetNewPasswordCode];
    [[QGTalosNetwork shareManager] POST:url parameters:parame success:^(id  _Nonnull responseObject) {
        //业务处理成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            //修改密码成功埋点
            NSMutableDictionary *info = [[NSMutableDictionary alloc] init];
            [info setObject:@"APP登录" forKey:@"abse_page_name"];
            [info setObject:@"短信找回密码" forKey:@"abse_action_name"];
            [info setObject:@"success" forKey:@"abse_state_value"];
            [QGAnalyticsService analyticsTrack:@"AppBusinessStateEvent" withProperties: info];
            
            QGAlertView *alert = [[QGAlertView alloc] initWithTitle:@"密码修改成功" message:@"请妥善保管好自己的账号和密码!" cancelButtonTitle:nil sureButtonTitle:@"知道了" clickBlock:^(NSInteger index) {
                if (index == 1) {
                    [self dismissPressed];
                }
            }];
            [alert showInView:self.view];
        }
        //业务处理异常
        else
        {
             [QGHUDManager showHudWithError:responseObject];
        }
        
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        [QGHUDManager showHud:[QGBaseNetwork getMessageWithFailureError:error]];
    }];
    
    
    
}


- (void)dismissPressed
{
    [self.navigationController dismissViewControllerAnimated:NO
                                                  completion:^{
                                                      if (self.callBackBlock) {
                                                          self.callBackBlock(LoginTag_QGMainLoginViewController_resetPassword, nil);
                                                      }
                                                  }];
}

-(void)checkLoginButtonStatus
{
    if (![NSString isEmpty:self.firstPassword] && ![NSString isEmpty:self.secondPassword]) {
        self.secondCell.titleColor = [UIColor textColor6666];
        self.secondCell.celltitle = @"再输一次";
        [self.loginButton setGradientButtonIsClickEnabled:YES];
    } else {
        
        [self.loginButton setGradientButtonIsClickEnabled:NO];

    }
}

#pragma mark --tableview delegate
-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 3;
}
-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row != 2) {
        return 81;
    }else{
        return 85;
    }
}
-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        
        QGPasswordInputWithTitleCell *cell = [tableView dequeueReusableCellWithIdentifier:@"newPassword"];
        if (!cell) {
            cell = [[QGPasswordInputWithTitleCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"newPassword" cellTitle:@"新登录密码"];
        }
        @weakify(self);
        cell.cellBlock = ^(NSString *password) {
            @strongify(self);
            self.firstPassword = password;
            [self checkLoginButtonStatus];
        };
        return cell;
    }else if (indexPath.row == 1){
        
        QGPasswordInputWithTitleCell *cell = [tableView dequeueReusableCellWithIdentifier:@"againPassword"];
        
        if (!cell) {
            cell = [[QGPasswordInputWithTitleCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"againPassword" cellTitle:@"再输一次"];        }
        @weakify(self);
        cell.cellBlock = ^(NSString *password) {
            @strongify(self);
            self.secondPassword = password;
            [self checkLoginButtonStatus];
        };
        self.secondCell = cell;
        return cell;
    }else{
        
        QGLoginBottomBtnTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([QGLoginBottomBtnTableViewCell class])];
        if (!cell) {
            cell = [[QGLoginBottomBtnTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([QGLoginBottomBtnTableViewCell class]) btnTitle:@"下一步" padding:20];
        }
        self.loginButton = cell.loginButton;
        
        @weakify(self)
        cell.cellBlock = ^(UIButton *nextBtn) {//下一步密码
            @strongify(self);

            [self setPassword];
        };        
        return cell;
    }
}


-(UIView *)tableHeaderView
{
    if (!_tableHeaderView) {
        _tableHeaderView = [[UIView alloc]init];
        _tableHeaderView.backgroundColor = [UIColor whiteColor];
        _tableHeaderView.bounds = CGRectMake(0, 0, MAINSCREEN_WIDTH, 65);
        
    }
    return _tableHeaderView;
}


-(BOOL)checkParameters:(NSDictionary *)param
{
    if ([[param objectForKey:@"phoneNumberStr"] isNumber] && ![NSString isEmpty:[param objectForKey:@"token"]]) {
        return YES;
    }
    
    return NO;
}

- (void)transferParameters:(NSDictionary *)param {
    
    self.phoneNumberStr = [param objectForKey:@"phoneNumberStr"];
    self.token = [param objectForKey:@"token"];
}

@end
