//
//  QGRetrievePasswordCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/19.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGRetrievePasswordCell.h"
#import "QGBasicUITool.h"
@interface QGRetrievePasswordCell ()
///竖线
@property (nonatomic, strong)UIView *verticalLine;
@end

@implementation QGRetrievePasswordCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier cellTitle:(NSString *)celltitle placeHolder:(NSString *)placholder
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier cellTitle:celltitle placeHolder:placholder]) {
        
        self.verticalLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        
        [self.phoneNumberinput.textField addTarget:self action:@selector(textFieldChange:) forControlEvents:UIControlEventEditingChanged];
        self.getcodeBtn = [UIButton creatButtonWithSuperView:self.contentView title:@"重新发送" titleFont:[UIFont qg_regularFontOfSize:15] textColor:[UIColor textColor3333]];
        self.getcodeBtn.userInteractionEnabled = NO;
        
        [self.getcodeBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.topMargin.mas_equalTo(30);
            make.right.equalTo(self.contentView).inset(20);
            make.height.mas_equalTo(41);
        }];
        
        [self.verticalLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.topMargin.mas_equalTo(35);
            make.right.equalTo(self.getcodeBtn.mas_left).offset(-10);
            make.width.mas_equalTo(1);
            make.height.mas_equalTo(30);
        }];
        
        [self.getcodeBtn addTarget:self action:@selector(getcodeBtnClick:) forControlEvents:UIControlEventTouchUpInside];
       
    }
    
    return self;
}

-(void)textFieldChange:(UITextField *)tx
{
    tx.text = [tx.text stringByReplacingOccurrencesOfString:@" " withString:@""];
    
    if (tx.text.length<=6) {
        if (self.cellBlock) {
            self.cellBlock(tx.text);
        }
    }else{
        tx.text = [tx.text substringWithRange:NSMakeRange(0, 6)];
        if (self.cellBlock) {
            self.cellBlock(tx.text);
        }
    }
}

-(void)getcodeBtnClick:(UIButton *)btn
{
    if (self.cellBtnCallBack) {
        self.cellBtnCallBack();
    }
}

@end
