//
//  CustomAlertView.m
//  CreditWallet
//
//  Created by 逍遥子 on 2017/9/19.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import "QGCustomAlertView.h"
#import "UIImageView+QGWebCache.h"
#import "UIView+Extend.h"
#import "QGBasicUITool.h"
#define ALERT_VIEW_WIDTH (MAINSCREEN_WIDTH - 43 * 2)

@interface QGCustomAlertView() <UITextFieldDelegate>

/**
 确认按钮
 */
@property (nonatomic, strong) UIButton *okBtn;

/**
 取消按钮
 */
@property (nonatomic, strong) UIButton *cancleBtn;

/**
 验证码输入框
 */
@property (nonatomic, strong) UITextField *imageCodeInputTextField;

/**
 图片验证码显示控件
 */
@property (nonatomic, strong) UIImageView *vCodeImageView;

/**
 输入框下面横线
 */
@property (nonatomic, strong) UIView *textFieldFootLineView;

/**
 横线线
 */
@property (nonatomic, strong) UIView *lineView;

/**
 底部竖线
 */
@property (nonatomic, strong) UIView *verLineView;

/**
 顶部通知栏
 */
@property (nonatomic, strong) UILabel *toastLabel;

/**
 顶部通知栏背景视图
 */
@property (nonatomic, strong) UIView *toastBackgroundView;

/**
 对话框背景视图
 */
@property (nonatomic, strong) UIView *alertBackgroundView;

@end

@implementation QGCustomAlertView

- (void)dealloc {
    NSLog(@"_______%@ dealloc", self);
    
    if (self.imageCodeInputTextField.delegate) {
        self.imageCodeInputTextField.delegate = nil;
    }
}

- (void)initNormalUI {
    [super initNormalUI];
    
    self.backgroundColor = [UIColor colorWithHexString:@"FFFFFF" alpha:0];
    self.frame = [UIScreen mainScreen].bounds;
    self.animationType = ZHAnimationTypeAlert;
    self.isCancleClickBackground = YES;
    
    self.toastBackgroundView.top = -40;
    
    self.imageCodeInputTextField.top = 37;
    self.imageCodeInputTextField.left = 14;
    self.imageCodeInputTextField.width = ALERT_VIEW_WIDTH - self.vCodeImageView.width - 30;
    
    self.vCodeImageView.left = self.imageCodeInputTextField.right;
    self.vCodeImageView.centerY = self.imageCodeInputTextField.centerY;
    
    self.textFieldFootLineView.top = 85;
    self.textFieldFootLineView.centerX = ALERT_VIEW_WIDTH * 0.5;
    
    self.lineView.bottom = self.alertBackgroundView.height - 50;
    self.cancleBtn.top = self.lineView.bottom;
    
    self.verLineView.left = self.cancleBtn.right;
    self.verLineView.top = self.lineView.bottom;
    
    self.okBtn.left = self.verLineView.right;
    self.okBtn.top = self.cancleBtn.top;
}

- (void)showAnimation:(BOOL)animation {
    [super showAnimation:animation];
    
    self.isShow = YES;
    [self.imageCodeInputTextField becomeFirstResponder];
}

- (void)dismissAnimation:(BOOL)animation dismissBlock:(BOOL)isBlock {
    [super dismissAnimation:animation dismissBlock:isBlock];
    
    self.isShow = NO;
    //隐藏时清空输入框
    self.imageCodeInputTextField.text = @"";
}

- (void)layoutSubviews {
    [super layoutSubviews];
    if (self.animationType == ZHAnimationTypeAlert) {
        self.alertBackgroundView.center = CGPointMake(MAINSCREEN_WIDTH / 2, (MAINSCREEN_HEIGHT - 216) / 2);
    }
}

#pragma mark - 响应事件处理
- (void)okBtnClick:(UIButton *)sender {
    if (self.imageCodeInputTextField.text.length == 0) {
        [self showDropDownToastWithMessage:@"请输入图片验证码"];
        return;
    }
    
    if ([self.delegate respondsToSelector:@selector(customAlertViewOKButtonClick:verifyCode:)]) {
        [self.delegate customAlertViewOKButtonClick:self verifyCode:self.imageCodeInputTextField.text];
    }
}

- (void)cancleButtonClick:(UIButton *)sender {
    [self dismissAnimation:YES dismissBlock:NO];
    if ([self.delegate respondsToSelector:@selector(customAlertViewCancleButtonClick:)]) {
        [self.delegate customAlertViewCancleButtonClick:self];
    }
}

- (void)verifyCodeImageViewClick {
    if ([self.delegate respondsToSelector:@selector(customAlertViewVerifyCodeImageViewClick:)]) {
        [self.delegate customAlertViewVerifyCodeImageViewClick:self];
    }
}

- (void)textFieldDidBeginEditing:(UITextField *)textField {
    self.alertBackgroundView.center = CGPointMake(MAINSCREEN_WIDTH / 2, (MAINSCREEN_HEIGHT - 216) / 2);
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    self.alertBackgroundView.center = CGPointMake(MAINSCREEN_WIDTH / 2, MAINSCREEN_HEIGHT / 2);
}

- (void)textFieldChanged:(UITextField*)textField {
    if ([textField.text isNumber] == NO) {
        textField.text = @"";
    } else if (textField.text.length >= 6) {
        textField.text = [textField.text substringToIndex:6];
    }
}

#pragma mark - 提示框
- (void)showDropDownToastWithMessage:(NSString *)message {
    if (self.isShow == NO) {
        return;
    }
    
    self.toastLabel.text = message ? message : @"";
    [self showDropDownToastAnimation:YES];
}

- (void)showDropDownToastAnimation:(BOOL)animation {
    self.toastBackgroundView.hidden = NO;
    self.toastBackgroundView.y = -self.toastBackgroundView.height;
    
    [UIView animateWithDuration:animation ? 0.25 : 0 animations:^{
        self.toastBackgroundView.y = [DeviceAdaptation getStatusBarHeight];
    } completion:^(BOOL finished) {
        [self performSelector:@selector(performDismiss) withObject:nil afterDelay:1.8];
    }];
}

- (void)performDismiss {
    [self dismissDropDownToastAnimation:YES];
}

- (void)dismissDropDownToastAnimation:(BOOL)animation {
    [UIView animateWithDuration:animation ? .25 :0 animations:^{
        self.toastBackgroundView.y = -self.toastBackgroundView.height;
    } completion:^(BOOL finished) {
        self.toastBackgroundView.hidden = YES;
    }];
}

#pragma mark - setter && getter
- (UILabel *)toastLabel {
    if (_toastLabel == nil) {
        _toastLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 15, MAINSCREEN_WIDTH, 20)];
        _toastLabel.backgroundColor = [UIColor colorWithHexString:@"B44B4D"];
        _toastLabel.font = [UIFont qg_regularFontOfSize:14];
        _toastLabel.textColor = [UIColor colorWithHexString:@"FFFFFF"];
        _toastLabel.textAlignment = NSTextAlignmentCenter;
        [self.toastBackgroundView addSubview:_toastLabel];
    }
    
    return _toastLabel;
}

- (UIView *)toastBackgroundView {
    if (_toastBackgroundView == nil) {
        _toastBackgroundView = [[UIView alloc] initWithFrame:CGRectMake(0, -40, MAINSCREEN_WIDTH, 40)];
        _toastBackgroundView.backgroundColor = [UIColor colorWithHexString:@"B44B4D"];
        [self addSubview:_toastBackgroundView];
    }
    
    return _toastBackgroundView;
}

- (UIView *)alertBackgroundView {
    if (_alertBackgroundView == nil) {
        _alertBackgroundView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, ALERT_VIEW_WIDTH, 170)];
        _alertBackgroundView.layer.cornerRadius = 6;
        _alertBackgroundView.clipsToBounds = YES;
        _alertBackgroundView.backgroundColor = [UIColor whiteColor];
        [self addSubview:_alertBackgroundView];
    }
    
    return _alertBackgroundView;
}

- (UIButton *)cancleBtn {
    if (_cancleBtn == nil) {
        _cancleBtn = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, (ALERT_VIEW_WIDTH - 1) / 2, 50)];
        [_cancleBtn setTitle:@"取消" forState:UIControlStateNormal];
        _cancleBtn.titleLabel.font = [UIFont qg_lightFontOfSize:18];
        [_cancleBtn setTitleColor:[UIColor colorWithHexString:@"333333"] forState:UIControlStateNormal];
        [_cancleBtn addTarget:self action:@selector(cancleButtonClick:) forControlEvents:UIControlEventTouchUpInside];
        [self.alertBackgroundView addSubview:_cancleBtn];
    }
    
    return _cancleBtn;
}

- (UITextField *)imageCodeInputTextField {
    if (_imageCodeInputTextField == nil) {
        _imageCodeInputTextField = [[UITextField alloc]initWithFrame:CGRectMake(14, 30, ALERT_VIEW_WIDTH - 98, 40)];
        _imageCodeInputTextField.borderStyle = UITextBorderStyleNone;
        _imageCodeInputTextField.placeholder = @"请输入图形验证码";
        _imageCodeInputTextField.font = [UIFont qg_lightFontOfSize:15];
        _imageCodeInputTextField.delegate = self;
        _imageCodeInputTextField.keyboardType = UIKeyboardTypeNumberPad;
        [_imageCodeInputTextField addTarget:self action:@selector(textFieldChanged:) forControlEvents:UIControlEventEditingChanged];
        [self.alertBackgroundView addSubview:_imageCodeInputTextField];
    }
    
    return _imageCodeInputTextField;
}

- (UIImageView *)vCodeImageView {
    if (_vCodeImageView == nil) {
        _vCodeImageView = [[UIImageView alloc] initWithFrame:CGRectMake(0, 0, 80, 28)];
        _vCodeImageView.userInteractionEnabled = YES;
        UITapGestureRecognizer *tapGesture = [[UITapGestureRecognizer alloc]initWithTarget:self action:@selector(verifyCodeImageViewClick)];
        [_vCodeImageView addGestureRecognizer:tapGesture];
        [self.alertBackgroundView addSubview:_vCodeImageView];
    }
    
    return _vCodeImageView;
}

- (UIView *)textFieldFootLineView {
    if (_textFieldFootLineView == nil) {
        _textFieldFootLineView = [[UIView alloc] init];
        _textFieldFootLineView.frame = CGRectMake(0, 0, ALERT_VIEW_WIDTH - 30, 0.5);
        _textFieldFootLineView.backgroundColor = [UIColor colorWithHexString:@"DCDCDC"];
        [self.alertBackgroundView addSubview:_textFieldFootLineView];
    }
    
    return _textFieldFootLineView;
}

- (UIView *)lineView {
    if (_lineView == nil) {
        _lineView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, ALERT_VIEW_WIDTH, 0.5)];
        _lineView.backgroundColor = [UIColor colorWithHexString:@"DCDCDC"];
        [self.alertBackgroundView addSubview:_lineView];
    }
    
    return _lineView;
}

- (UIView *)verLineView {
    if (_verLineView == nil) {
        _verLineView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 0.5, 50)];
        _verLineView.backgroundColor = [UIColor colorWithHexString:@"DCDCDC"];
        [self.alertBackgroundView addSubview:_verLineView];
    }
    
    return _verLineView;
}

- (UIButton *)okBtn {
    if (_okBtn == nil) {
        _okBtn = [[UIButton alloc] initWithFrame:CGRectMake(0, 0, (ALERT_VIEW_WIDTH - 1) / 2 + 1, 50)];
        [_okBtn setTitle:@"确定" forState:UIControlStateNormal];
        _okBtn.titleLabel.font = [UIFont qg_regularFontOfSize:18];
        [_okBtn setTitleColor:[UIColor colorWithHexString:@"B44B4D"] forState:UIControlStateNormal];
        [_okBtn addTarget:self action:@selector(okBtnClick:) forControlEvents:UIControlEventTouchUpInside];
        [self.alertBackgroundView addSubview:_okBtn];
    }
    
    return _okBtn;
}

- (void)setVCodeImage:(UIImage *)vCodeImage {
    if (_vCodeImage != vCodeImage) {
        _vCodeImage = vCodeImage;
        self.vCodeImageView.image = _vCodeImage;
    }
}

@end
