//
//  CustomAlertView.h
//  CreditWallet
//
//  Created by 逍遥子 on 2017/9/19.
//  Copyright © 2017年 QuantGroup. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "ZHAnimationBaseView.h"

@class QGCustomAlertView;

@protocol QGCustomAlertViewDelegate <NSObject>

/**
 图片验证码按钮点击事件
 */
- (void)customAlertViewVerifyCodeImageViewClick:(QGCustomAlertView *)sender;

/**
 确认按钮点击事件
 
 */
- (void)customAlertViewOKButtonClick:(QGCustomAlertView *)sender verifyCode:(NSString *)verifyCode;

@optional

/**
 取消按钮点击事件
 
 */
- (void)customAlertViewCancleButtonClick:(QGCustomAlertView *)sender;

@end

@interface QGCustomAlertView : ZHAnimationBaseView

/**
 验证码图片
 */
@property (nonatomic,strong) UIImage *vCodeImage;

/**
 yes:当前处于显示状态  no:已经被隐藏
 */
@property (nonatomic, assign) BOOL isShow;

/**
 代理对象
 */
@property (nonatomic, weak) id <QGCustomAlertViewDelegate> delegate;

/**
 展示下拉提示信息

 @param message 下拉提示框显示的消息
 */
- (void)showDropDownToastWithMessage:(NSString *)message;

@end


