//
//  QGMainLoginViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/14.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGPasswordLoginViewController.h"
#import "QGBasicUITool.h"
#import "QGLoginTableViewCell.h"
#import "QGLoginInputPasswordTableViewCell.h"
#import "QGLoginBottomBtnTableViewCell.h"
#import "QGBottomLittleBtnTableViewCell.h"
#import "QGLoginProtocolCell.h"
#import "QGLoginRequestApi.h"
#import "QGCalendarManager.h"
#import "QGCustomAlertView.h"
#import "QGPushService.h"
@interface QGPasswordLoginViewController ()<QGCustomAlertViewDelegate>
///自定义tableView header
@property (nonatomic, strong)UIView *tableHeaderView;
///手机号
@property (nonatomic, copy)NSString *phoneString;
///密码
@property (nonatomic, copy)NSString *passwordString;
///登录按钮是否可点击的设置
@property (nonatomic, copy)void(^changeButtonStatus)(BOOL ableClick);


/**
 图片验证码的图片
 */
@property (nonatomic, strong) UIImage *imageVerifyCodeImage;

/**
 图片验证码信息
 */
@property (nonatomic, strong) NSMutableDictionary *imageVerifyCodeInfo;

/**
 图片验证码弹框
 */
@property (strong, nonatomic) QGCustomAlertView *customAlertView;

/**
 图片验证码
 */
@property (nonatomic, strong) NSString *imageVerifyCode;

///是否已同意用户协议
@property (assign, nonatomic) BOOL isSelect;

@end

@implementation QGPasswordLoginViewController

-(BOOL)checkParameters:(NSDictionary *)param
{
    return YES;
}

-(void)transferParameters:(NSDictionary *)param
{
    self.phoneString = [param objectForKey:@"phone"];
}


- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    self.tableView.bounces = NO;
    
    //设置tableview的header
    UILabel *welcomeLabel = [UIView creatLabelWithSuperView:self.tableHeaderView title:@"欢迎使用真享生活" titleFontSize:[UIFont qg_regularFontOfSize:30] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [welcomeLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.right.left.equalTo(self.tableHeaderView).inset(40);
        make.top.equalTo(self.tableHeaderView).inset(48);
        make.height.mas_equalTo(30);
    }];
    self.tableView.tableHeaderView = self.tableHeaderView;
}


//登录按钮点击提交用户名密码
- (void)submitBtnClick:(UIButton *)sender {
    
    if (!self.isSelect) {
        [QGHUDManager showHud:@"请您仔细阅读并同意相关协议"];
        return;
    }
    
    [self.view endEditing:YES];
    
    if (self.phoneString.length != 11 || !self.phoneString.isNumber) {
        [QGHUDManager showHud:@"手机号格式不正确"];
        return;
    }
    
    
    NSMutableDictionary *paraDictM = [[NSMutableDictionary alloc] init];
    
    if (self.imageVerifyCode != nil) {
        [paraDictM setValue:self.imageVerifyCode forKey:@"captchaValue"];
    }
    
    if ([self.imageVerifyCodeInfo objectForKey:@"imageId"] != nil) {
        [paraDictM setValue:[self.imageVerifyCodeInfo objectForKey:@"imageId"] forKey:@"captchaId"];
    }
    
    [paraDictM setValue:self.phoneString forKey:@"loginName"];
    [paraDictM setValue:self.passwordString forKey:@"password"];
    
    [QGHUDManager showHud:nil];
    QGTalosNetwork *mananger = [QGTalosNetwork shareManager];
    [mananger POST:[QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodLogin] parameters:paraDictM success:^(id  _Nonnull responseObject) {
        [QGHUDManager hideHud];
        NSDictionary * json = (NSDictionary *) responseObject;
        //业务处理成功
        if ([QGTalosNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            if (self.customAlertView.isShow) {
                [self.customAlertView dismissAnimation:YES dismissBlock:NO];
            }
            [self loginSuccessSaveUserInfo:json[@"data"]];
        }
        //业务处理失败 此处为迁移旧的业务逻辑 zhangbo
        else
        {
            NSString * businessCode = [json objectForKey:@"businessCode"];
            //图形验证码错误
            if ([businessCode isEqualToString:@"1001"]) {
                //图片验证码处理逻辑
                //如果验证码弹框已经弹出了，则将服务器返回的错误信息展示到该弹框所在层级
                if (self.customAlertView.isShow) {
                   [self.customAlertView showDropDownToastWithMessage:@"图形验证码不正确"];
                }
                //获取验证码
                [self getImageCodeWithAlertView:YES];
            }
            else
            {
                //隐藏图片验证码弹框
                if (self.customAlertView.isShow) {
                    [self.customAlertView dismissAnimation:YES dismissBlock:NO];
                }
                [QGHUDManager showHudWithError:responseObject];
            }
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMsg = [QGTalosNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMsg];
    }];
    
    /*
    [mananger POST:[QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodLogin]
        parameters:paraDictM
           success:^(id responseObject) {
               [QGHUDManager hideHud];
               if (self.customAlertView.isShow) {
                   [self.customAlertView dismissAnimation:YES dismissBlock:NO];
               }
               
               NSDictionary *json = (NSDictionary *) responseObject;
               [self loginSuccessSaveUserInfo:json];
           }failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
               [QGHUDManager hideHud];
               
               NSDictionary *json = (NSDictionary *) [QGBaseNetwork getFailureResponseDicWithError:error];
               
               if ([json isKindOfClass:[NSDictionary class]]) {

                   NSInteger code = [[json objectForKey:@"code"] integerValue];
                   if (code == 2) {
                       //图片验证码处理逻辑
                       self.verifyCodeInvalidCount++;
                       
                       //如果验证码弹框已经弹出了，则将服务器返回的错误信息展示到该弹框所在层级
                       if (self.customAlertView.isShow) {
                           if ([json objectForKey:@"message"]) {
                               self.verifyCodeInvalidCount = 0;
                               [self.customAlertView showDropDownToastWithMessage:[json objectForKey:@"message"]];
                           }
                       }
                       
                       //获取验证码
                       [self getImageCodeWithAlertView:YES];
                       return;
                   }
                   
                   //隐藏图片验证码弹框
                   if (self.customAlertView.isShow) {
                       [self.customAlertView dismissAnimation:YES dismissBlock:NO];
                   }
                   
                   //显示错误信息
                   if ([json objectForKey:@"message"]) {
                       [QGHUDManager showHud:[json objectForKey:@"message"]];
                   } else {
                       NSString *errorMsg = @"";
                       if (code == 1) {
                           errorMsg = @"用户名或密码不正确";
                       } else {
                           errorMsg = @"图形验证码不正确";
                       }
                       
                       [QGHUDManager showHud:errorMsg];
                   }
                   
               } else {
                   [QGHUDManager showHud:@"似乎已断开与互联网的连接"];
               }
           }];
     */
    
    
}

#pragma mark - 图形验证码处理方法

- (void)showCustomAlertView {
    [self.view endEditing:YES];
    if (self.phoneString.length == 0) {
        [QGHUDManager showHud:@"请输入手机号"];
        return;
    }
    
    if (self.phoneString.length != 11 && self.phoneString.isNumber) {
        [QGHUDManager showHud:@"请输入正确的手机号"];
        return;
    }
    
    self.customAlertView.vCodeImage = self.imageVerifyCodeImage;
    
    if (self.customAlertView.isShow == NO) {
        [self.customAlertView showAnimation:YES];
    }
}

- (void)customAlertViewVerifyCodeImageViewClick:(QGCustomAlertView *)sender {
    [self getImageCodeWithAlertView:NO];
}

- (void)customAlertViewOKButtonClick:(QGCustomAlertView *)sender verifyCode:(NSString *)verifyCode {
    self.imageVerifyCode = verifyCode;
    [self submitBtnClick:nil];
}

- (void)getImageCodeWithAlertView:(BOOL)showCustomAlertView {
    
    
    NSString *urlString = [QGLoginRequestApi urlWithQGLoginRequestServerMethod:QGLoginRequestServerMethodSmsCaptcha];
    
    [[QGTalosNetwork shareManager] GET:urlString parameters:nil success:^(id  _Nonnull responseObject) {
        //业务处理成功
        if ([QGBaseNetwork checkBusinessCodeAndCodeWithResponseObjectObject:responseObject]) {
            NSDictionary *json = (NSDictionary *)responseObject[@"data"];
            [self.imageVerifyCodeInfo setDictionary:json];
            if ([self.imageVerifyCodeInfo objectForKey:@"image"]) {
               NSString *aString = [self.imageVerifyCodeInfo objectForKey:@"image"];
               NSArray *imageArray = [aString componentsSeparatedByString:@","];
               NSString *string = [imageArray[1] stringByReplacingOccurrencesOfString:@" " withString:@""];
               NSData *imageData = [[NSData alloc] initWithBase64EncodedString:string options:NSDataBase64DecodingIgnoreUnknownCharacters];
               self.imageVerifyCodeImage = [UIImage imageWithData:imageData];
               
               if (showCustomAlertView) {
                   [self showCustomAlertView];
               } else {
                   self.customAlertView.vCodeImage = self.imageVerifyCodeImage;
               }
            }
        }
        //业务处理失败
        else
        {
            NSString *messageStr = [NSString stringWithFormat:@"%@", [responseObject objectForKey:@"msg"]];
            if (self.customAlertView.isShow) {
                [self.customAlertView showDropDownToastWithMessage:messageStr];
            } else {
                [QGHUDManager showHud:messageStr];
            }
        }
        
    } failure:^(NSURLSessionDataTask * _Nonnull task, NSError * _Nonnull error) {
        NSString * errorMsg = [QGBaseNetwork getMessageWithFailureError:error];
        [QGHUDManager showHud:errorMsg];
    }];
}




//登录成功之后的处理
- (void)loginSuccessSaveUserInfo:(NSDictionary *)responseObject
{
    
    if ([responseObject valueForKey:@"token"]) {
        [QGHUDManager showHud:@"登录成功"];
        [QGAnalyticsService analyticsLoginWithUUID:[responseObject objectForKey:@"uuid"]];
        
        //登陆成功埋点
        NSMutableDictionary *info = [[NSMutableDictionary alloc] init];
        [info setObject:@"APP登录" forKey:@"abse_page_name"];
        [info setObject:@"密码登录" forKey:@"abse_action_name"];
        [info setObject:@"success" forKey:@"abse_state_value"];
        [QGAnalyticsService analyticsTrack:@"AppBusinessStateEvent" withProperties: info];

        
        
        //存储登录信息()
        [QGUserInfo sharedUserInfo].userName = responseObject[@"phoneNo"];
        [QGUserInfo sharedUserInfo].token = [responseObject objectForKey:@"token"];
        [QGUserInfo sharedUserInfo].vccRefreshToken = [responseObject objectForKey:@"vccRefreshToken"];
        [QGUserInfo sharedUserInfo].uuid = [responseObject objectForKey:@"uuid"];
        [QGUserInfo sharedUserInfo].userId = [NSString stringWithFormat:@"%@", responseObject[@"userId"]];
        [QGUserInfo sharedUserInfo].alimamaAuth = [responseObject[@"alimamaAuth"] boolValue];
        [QGUserInfo sharedUserInfo].login = YES;
        //密码登陆成功，说明有密码
        [QGUserInfo sharedUserInfo].hasPassword = YES;
        [QGPushService setPushAccount:[QGUserInfo sharedUserInfo].userId];
        
        //发送登录成功的全局通知
        [[NSNotificationCenter defaultCenter] postNotificationName:ModelCenterUserLoginNotification object:nil];
        //退出登录模块
        [self performSelector:@selector(dismissPressed) withObject:nil afterDelay:0.2];
    }
}




/**
 登录完成后取消当前页面
 */
- (void)dismissPressed
{
    [self.view endEditing:YES];
    [self.navigationController dismissViewControllerAnimated:NO
                             completion:^{
                                 if (self.callBackBlock) {
                                     self.callBackBlock(LoginTag_QGMainLoginViewController_LoginSuccess, nil);
                                 }
                             }];
}

#pragma mark - UITableViewDataSource

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return 5;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    switch (indexPath.row) {
        case 0:
        {  //手机号输入框
            
            
            QGLoginTableViewCell *cell = (QGLoginTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGLoginTableViewCell class]) dequeueTableView:tableView];
            cell.selectionStyle = UITableViewCellSelectionStyleNone;
            @weakify(self)
            
            cell.phoneNumberinput.textField.text = self.phoneString;
            
            cell.cellBlock = ^(NSString *phoneNumber) {
                @strongify(self)
                self.phoneString = phoneNumber;
                
                if (self.callBackBlock) {
                    self.callBackBlock(LoginTag_QGLoginViewController_ChangePhoneNum, @{@"phone":self.phoneString});
                }
                
                if (self.phoneString.isNumber&&self.phoneString.length == 11 && ![NSString isEmpty:self.passwordString]) {
                    //登录按钮可点击
                    self.changeButtonStatus(YES);
                } else {
                    //登录按钮不可点击
                    self.changeButtonStatus(NO);
                }
                
            };
            
            return cell;
        
        }
            break;

        case 1:
        {   // 密码输入框
            QGLoginInputPasswordTableViewCell *cell = (QGLoginInputPasswordTableViewCell *)[self getCellFromClassName:NSStringFromClass([QGLoginInputPasswordTableViewCell class]) dequeueTableView:tableView];
            @weakify(self)
            cell.cellBlock = ^(NSString *password) {
                @strongify(self)
                self.passwordString = password;
                if (self.phoneString.isNumber&&self.phoneString.length == 11 && ![NSString isEmpty:self.passwordString]) {
                    //登录按钮可点击
                    self.changeButtonStatus(YES);
                } else {
                    //登录按钮不可点击
                    self.changeButtonStatus(NO);
                }
                
            };
            
            return cell;
        }
            break;
            //协议
        case 2:
        {
            QGLoginProtocolCell * cell = (QGLoginProtocolCell *)[self getCellFromClassName:NSStringFromClass([QGLoginProtocolCell class]) dequeueTableView:tableView];
            cell.isAgree = self.isSelect;
            
            @weakify(self);
            //注册协议
            cell.registerProtocolClick = ^{
                @strongify(self);
                [self navigationToWeb:VCCRegisterAgreement];
            };
            
            //隐私协议
            cell.privacyProtocolClick = ^{
                @strongify(self);
                [self navigationToWeb:VCCPrivacyAgreement];
            };
            
            //同意协议
            cell.agressClick = ^{
                @strongify(self);
                self.isSelect = !self.isSelect;
            };
            
            return cell;
        }
            break;
        case 3:
        {   //登录按钮
            
            
            QGLoginBottomBtnTableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:NSStringFromClass([QGLoginBottomBtnTableViewCell class])];
            
            if (!cell) {
                cell = [[QGLoginBottomBtnTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:NSStringFromClass([QGLoginBottomBtnTableViewCell class]) btnTitle:@"登录" padding:40];
            }
            
            @weakify(self);
            cell.cellBlock = ^(UIButton *nextBtn) {
                @strongify(self);
                //登录按钮点击事件
                [self submitBtnClick:nextBtn];
            };
            
            self.changeButtonStatus = ^(BOOL ableClick) {
                
                [cell.loginButton setGradientButtonIsClickEnabled:ableClick];
            };
            
            return cell;
        }
            break;

        case 4:
        {
            QGBottomLittleBtnTableViewCell *cell = [[QGBottomLittleBtnTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"little" leftBtnTitle:@"验证码登录" rightBtnTitle:@"忘记密码"];
            cell.selectionStyle = UITableViewCellSelectionStyleNone;

            @weakify(self);
            cell.cellBlock = ^(LittleBtnType btnType) {//处理按钮点击逻辑
                @strongify(self);
                switch (btnType) {
                    case LittleBtnVerifyCode:{
                        //验证码登录页面跳转
                        [self.navigationController popViewControllerAnimated:YES];
                    }
                        break;
                    case LittleBtnForgetPassword:
                    {
                        //忘记密码页面跳转
                        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGLoginResetPasswordViewController] isPush:NO parameters:nil handlerBlock:^(NSString *tag, NSDictionary *parameters) {
                            if ([tag isEqualToString:LoginTag_QGMainLoginViewController_resetPassword]) {
                                NSLog(@"修改密码成功哈哈哈哈");
                            }
                        }];
                    }
                        break;
                    default:
                        break;
                }
                
            };
            
            return cell;
        }
            break;

        default:
            return [UITableViewCell new];
            break;
    }
}

#pragma mark - UITableViewDelegate


-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 2) {
        return [QGLoginProtocolCell cellHeight];
    }
    else if (indexPath.row == 3) {
        return 40.f;
    }else if (indexPath.row == 4){
        return 60.f;
    }else {
        return 63.f;
    }
}


-(UIView *)tableHeaderView
{
    if (!_tableHeaderView) {
        _tableHeaderView = [[UIView alloc]init];
        _tableHeaderView.backgroundColor = [UIColor whiteColor];
        _tableHeaderView.bounds = CGRectMake(0, 0, MAINSCREEN_WIDTH, 140);
        
    }
    return _tableHeaderView;
}

- (NSMutableDictionary *)imageVerifyCodeInfo {
    if (_imageVerifyCodeInfo == nil) {
        _imageVerifyCodeInfo = [[NSMutableDictionary alloc] initWithCapacity:1];
    }
    
    return _imageVerifyCodeInfo;
}

- (QGCustomAlertView *)customAlertView {
    if (_customAlertView == nil) {
        _customAlertView = [[QGCustomAlertView alloc] init];
        _customAlertView.delegate = self;
    }
    
    return _customAlertView;
}





@end
