//
//  QGLoginSelectResetPasswordTypeViewController.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/19.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGLoginSelectResetPasswordTypeViewController.h"
#import "QGBasicUITool.h"
#import "QGSelectTypeTableViewCell.h"
#import "QGSendMessageCodeManger.h"

//为了实现方式一致 创建底部buttoncell，
@interface QGBottomCell:UITableViewCell

@property (nonatomic, copy)void(^cellBlock)(void);



@end

@implementation QGBottomCell
-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        UIButton *back = [UIButton creatButtonWithSuperView:self.contentView title:@"修改其他账号密码" titleFont:[UIFont qg_lightFontOfSize:12] textColor:[UIColor mainThemeColor]];
        back.layer.cornerRadius = 12;
        back.layer.borderColor = [UIColor mainThemeColor].CGColor;
        back.layer.borderWidth = 0.5;
        
        [back mas_makeConstraints:^(MASConstraintMaker *make) {
            make.topMargin.mas_equalTo(45);
            make.width.mas_equalTo(140);
            make.height.mas_equalTo(24);
            make.centerX.equalTo(self.contentView);
        }];
        [back addTarget:self action:@selector(click:) forControlEvents:UIControlEventTouchUpInside];
    }
    return self;
}

-(void)click:(UIButton *)btn
{
    if (self.cellBlock) {
        self.cellBlock();
    }
}

@end

@interface QGLoginSelectResetPasswordTypeViewController ()
///自定义tableView header
@property (nonatomic, strong)UIView *tableHeaderView;

///手机号
@property (nonatomic, copy)NSString *phoneNumberStr;

@end

@implementation QGLoginSelectResetPasswordTypeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self custemLeftDefaultBarButtonItem];
    [self setIsBelowNavBar:NO];
    [self setNavBarBottomLineHidden:YES];
    self.title = @"修改登录密码";
    
    //创建header
    UILabel *titleLable = [UILabel creatLabelWithSuperView:self.tableHeaderView title:[NSString stringWithFormat:@"您绑定的手机号 %@",self.phoneNumberStr] titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    UILabel *subTitleLable = [UILabel creatLabelWithSuperView:self.tableHeaderView title:@"是否能接收短信？" titleFontSize:[UIFont qg_mediumFontOfSize:18] textColor:[UIColor textColor3333] alignment:NSTextAlignmentLeft];
    [titleLable mas_makeConstraints:^(MASConstraintMaker *make) {
        make.topMargin.mas_equalTo(20);
        make.left.right.equalTo(self.tableHeaderView).inset(20);
        make.height.mas_equalTo(20);
    }];
    [subTitleLable mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(titleLable.mas_bottom).offset(10);
        make.left.right.equalTo(self.tableHeaderView).inset(20);
        make.height.mas_equalTo(20);
    }];
    self.tableView.tableHeaderView = self.tableHeaderView;
        
}



-(NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return 3;
}
-(CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 2) {
        return 69;
    }else{
        return 61;
    }
}
-(UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {
        QGSelectTypeTableViewCell *cell = [[QGSelectTypeTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"cell1"];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.titleLabel.text = @"原手机号能接收短信";
        return cell;
    }else if(indexPath.row == 1){
        QGSelectTypeTableViewCell *cell = [[QGSelectTypeTableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"cell2"];
        cell.selectionStyle = UITableViewCellSelectionStyleNone;
        cell.titleLabel.text = @"自助申请";

        return cell;
    }else{
        
        QGBottomCell *cell = [[QGBottomCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"bottom"];
        
        cell.cellBlock = ^{
            [self.navigationController popViewControllerAnimated:YES];
        };
        
        return cell;
        
    }
}

-(void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    if (indexPath.row == 0) {//原手机号可以接收短信，获取验证码
//        __weak typeof(self)weakSelf = self;
        [Mediator performTarget:[QGMediatorClassTools QGClassNameWithHeaderType:QGHeaderTypeQGRetriecePasswordViewController] parameters:@{@"phoneNumberStr":self.phoneNumberStr} handlerBlock:self.callBackBlock];

    }else if (indexPath.row == 1){//自助申请
         [self navigationToWeb:@"https://vcc.xyqb.com/helpDetail"];
    }
}


-(UIView *)tableHeaderView
{
    if (!_tableHeaderView) {
        _tableHeaderView = [[UIView alloc]init];
        _tableHeaderView.backgroundColor = [UIColor whiteColor];
        _tableHeaderView.bounds = CGRectMake(0, 0, MAINSCREEN_WIDTH, 90);

    }
    return _tableHeaderView;
}


-(BOOL)checkParameters:(NSDictionary *)param
{
    if ([[param objectForKey:@"phoneNumberStr"] isNumber]) {
        return YES;
    }
    
    return NO;
}

- (void)transferParameters:(NSDictionary *)param {
    
    self.phoneNumberStr = [param objectForKey:@"phoneNumberStr"];
}


@end




