//
//  QGVerifyCodeCell.m
//  VirtualPayment
//
//  Created by 张博 on 2020/5/22.
//  Copyright © 2020 bo.zhang. All rights reserved.
//

#import "QGBindingVerifyCodeCell.h"
#import "QGInputGroupView.h"

#import "QGBasicUITool.h"
@interface QGBindingVerifyCodeCell ()

/// 验证码输入框
@property (nonatomic, strong) QGInputGroupView * codeInputView;

/// 验证码按钮
@property (nonatomic, strong, readwrite) UIButton * codeButton;

@end

@implementation QGBindingVerifyCodeCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        //验证码
        self.codeInputView = [[QGInputGroupView alloc]initWithType:InputViewTypeText title:nil placeHolder:@"请输入短信验证码"];
        [self.codeInputView.textField addTarget:self action:@selector(textFieldChange:) forControlEvents:UIControlEventEditingChanged];
        self.codeInputView.textField.keyboardType = UIKeyboardTypeNumberPad;
        [self.contentView addSubview:self.codeInputView];
        
        [self.codeInputView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.contentView).offset(10);
            make.left.inset(40);
            make.right.inset(139);
            make.height.mas_equalTo(45);
        }];
        
        //竖直分割线
        UIView * segLineView = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [segLineView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.size.mas_equalTo(CGSizeMake(0.5, 36));
            make.centerY.mas_equalTo(self.codeInputView);
            make.left.mas_equalTo(self.codeInputView.mas_right);
        }];
        
        //验证码按钮
        self.codeButton = [UIButton creatButtonWithSuperView:self.contentView title:@"获取验证码" titleFont:[UIFont qg_lightFontOfSize:16] textColor:[UIColor textColor3333]];
        [self.codeButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(segLineView.mas_right);
            make.height.mas_equalTo(36);
            make.right.inset(40);
            make.centerY.mas_equalTo(self.codeInputView);
        }];
        
        //底部线条
        UIView * underLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        [underLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.inset(40);
            make.top.equalTo(self.codeInputView.mas_bottom).offset(7);
            make.height.mas_equalTo(0.5);
        }];
        
    }
    return self;
}


-(void)textFieldChange:(UITextField *)tx
{
    tx.text = [tx.text stringByReplacingOccurrencesOfString:@""  withString:@""];
    if (tx.text.length<=11) {
        if (self.cellBlock) {
            self.cellBlock(tx.text);
        }
    }else{
        tx.text = [tx.text substringWithRange:NSMakeRange(0, 11)];
        if (self.cellBlock) {
            self.cellBlock(tx.text);
        }
    }

}





- (void)setSelected:(BOOL)selected animated:(BOOL)animated {
    [super setSelected:selected animated:animated];

    // Configure the view for the selected state
}

@end
