//
//  QGPhoneInputWithTitleCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/18.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGPhoneInputWithTitleCell.h"
#import "QGBasicUITool.h"



@implementation QGPhoneInputWithTitleCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier cellTitle:(NSString *)celltitle placeHolder:(NSString *)placholder
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        _celltitle = celltitle;
        _placholder = placholder;
        [self.contentView addSubview:self.phoneNumberinput];
        self.passwordUnderLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        [self.phoneNumberinput mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.contentView).offset(16);
            make.left.right.equalTo(self.contentView).inset(self.padding?self.padding:20);
            make.height.mas_equalTo(48);
        }];
        
        [self.passwordUnderLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.phoneNumberinput);
            make.top.equalTo(self.phoneNumberinput.mas_bottom).offset(16.5);
            make.height.mas_equalTo(0.5);
        }];
        self.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    
    return self;
}


-(void)textFieldChange:(UITextField *)tx
{
    tx.text = [tx.text stringByReplacingOccurrencesOfString:@" " withString:@""];
    
    if (tx.text.length<=11) {
        if (self.cellBlock) {
            self.cellBlock(tx.text);
        }
    }else{
        tx.text = [tx.text substringWithRange:NSMakeRange(0, 11)];
        if (self.cellBlock) {
            self.cellBlock(tx.text);
        }
    }
}

- (void)setCelltitle:(NSString *)celltitle
{
    _celltitle = celltitle;
    self.phoneNumberinput.title = _celltitle;
}

- (void)setTitleColor:(UIColor *)titleColor
{
    _titleColor = titleColor;
    self.phoneNumberinput.titleColor = _titleColor;
}

-(void)setPadding:(CGFloat)padding
{
    _padding = padding;
    
    [self.phoneNumberinput mas_updateConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.contentView).offset(16);
        make.left.right.equalTo(self.contentView).inset(padding);
        make.height.mas_equalTo(48);
    }];
  
}


-(QGInputGroupView *)phoneNumberinput
{
    if (!_phoneNumberinput) {
        _phoneNumberinput = [[QGInputGroupView alloc]initWithType:InputViewTypeTextHint title:self.celltitle placeHolder:self.placholder?self.placholder:@"请输入手机号"];
        [_phoneNumberinput.textField addTarget:self action:@selector(textFieldChange:) forControlEvents:UIControlEventEditingChanged];
        _phoneNumberinput.textField.keyboardType = UIKeyboardTypeNumberPad;
        _phoneNumberinput.accessoryButton.hidden = YES;
        _phoneNumberinput.textField.clearButtonMode = UITextFieldViewModeNever;
    }
    return _phoneNumberinput;
}



@end
