//
//  QGPasswordInputWithTitleCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/18.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGPasswordInputWithTitleCell.h"
#import "QGInputGroupView.h"
#import "QGBasicUITool.h"

@interface QGPasswordInputWithTitleCell()

@property (nonatomic, strong)QGInputGroupView *passwordInputView;
@property (nonatomic, strong)UIView *passwordUnderLine;

@end

@implementation QGPasswordInputWithTitleCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier cellTitle:(NSString *)celltitle
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        _celltitle = celltitle;
        [self.contentView addSubview:self.passwordInputView];
        self.passwordUnderLine = [UIView creatViewWithSuperView:self.contentView backgroundColor:[UIColor lineSeparatorColorDCDC]];
        
        [self.passwordInputView mas_makeConstraints:^(MASConstraintMaker *make) {
            make.top.equalTo(self.contentView).offset(16);
            make.left.right.equalTo(self.contentView).inset(20);
            make.height.mas_equalTo(48);
        }];
        
        [self.passwordUnderLine mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.passwordInputView);
            make.top.equalTo(self.passwordInputView.mas_bottom).offset(16.5);
            make.height.mas_equalTo(0.5);
        }];

        
        self.selectionStyle = UITableViewCellSelectionStyleNone;

    }
    
    return self;
}

///输入框改变
-(void)textFieldChange:(UITextField *)tx
{
    if (self.cellBlock) {
        self.cellBlock(tx.text);
    }
}

- (void)setHideUnderLine:(BOOL)hideUnderLine
{
    _hideUnderLine = hideUnderLine;
    self.passwordUnderLine.hidden = hideUnderLine;
}

///设置cell的title
- (void)setCelltitle:(NSString *)celltitle
{
    _celltitle = celltitle;
    self.passwordInputView.title = _celltitle;
}
///设置title的颜色
- (void)setTitleColor:(UIColor *)titleColor
{
    _titleColor = titleColor;
    self.passwordInputView.titleColor = _titleColor;
}


-(QGInputGroupView *)passwordInputView
{
    if (!_passwordInputView) {
        _passwordInputView = [[QGInputGroupView alloc]initWithType:InputViewTypePwd title:self.celltitle placeHolder:@"8-20位字母、数字混合"];
        [_passwordInputView.textField addTarget:self action:@selector(textFieldChange:) forControlEvents:UIControlEventEditingChanged];
    }
    return _passwordInputView;
}


@end
