//
//  QGLoginBottomBtnTableViewCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/17.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGLoginBottomBtnTableViewCell.h"

@implementation QGLoginBottomBtnTableViewCell

-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier btnTitle:(NSString *)btnTitle padding:(CGFloat)padding
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        _padding = padding;
        self.loginButton = [QGGradientShadowButton creatGradientColorButtonWithSuperView:self.contentView title:btnTitle textFont:[UIFont qg_regularFontOfSize:17]];
        [self.loginButton setGradientButtonIsClickEnabled:NO];
        
        [self.loginButton addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        self.selectionStyle = UITableViewCellSelectionStyleNone;
        
        [self.loginButton mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.right.equalTo(self.contentView).inset(self.padding?self.padding:40);
            make.height.mas_equalTo(40);
            make.bottom.equalTo(self.contentView);
        }];
        
        self.selectionStyle = UITableViewCellSelectionStyleNone;

    }
    
    return self;
}


-(void)btnClick:(UIButton *)btn
{
    if (self.cellBlock) {
        self.cellBlock(btn);
    }
}


@end
