//
//  QGInputVerifyCodeView.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/14.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGInputVerifyCodeView.h"
#import "UIColor+QGColor.h"
#import "UIFont+QGFont.h"
@interface QGInputVerifyCodeView ()
///验证码的个数
@property (nonatomic, assign) NSInteger itemCount;
///文字下划线宽度
@property (nonatomic, assign) CGFloat itemWidth;
///底层验证码输入框
@property (nonatomic, weak) UITextField *textField;
///输入框上层遮盖
@property (nonatomic, weak) UIControl *maskView;
///显示label数组
@property (nonatomic, strong) NSMutableArray<UILabel *> *labels;
///文字下划线数组
@property (nonatomic, strong) NSMutableArray<UIView *> *lines;


@end

@implementation QGInputVerifyCodeView

#pragma mark - 初始化
- (instancetype)initWithCount:(NSInteger)count itemWidth:(CGFloat)itemWidth
{
    if (self = [super init]) {
        self.itemCount = count;
        self.itemWidth = itemWidth;
        [self configTextField];
    }
    return self;
}

//输入的回调
-(instancetype)getInputVerifyCodeblock:(void(^)(NSString *code,BOOL complete))codeBlock
{
    self.codeBlock = codeBlock;
    return self;
}
//设置ui
- (void)configTextField
{
    self.backgroundColor = [UIColor whiteColor];
    //初始化数组
    self.labels = [[NSMutableArray alloc] init];
    self.lines = [[NSMutableArray alloc] init];
    
    //创建输入框
    UITextField *textField = [[UITextField alloc] init];
    textField.autocapitalizationType = UITextAutocapitalizationTypeNone;
    textField.keyboardType = UIKeyboardTypeNumberPad;
    [textField addTarget:self action:@selector(tfEditingChanged:) forControlEvents:(UIControlEventEditingChanged)];
    [self addSubview:textField];
    self.textField = textField;
    
    //创建遮罩响应点击事件
    UIButton *maskView = [UIButton new];
    maskView.backgroundColor = [UIColor whiteColor];
    [maskView addTarget:self action:@selector(clickMaskView) forControlEvents:(UIControlEventTouchUpInside)];
    [self addSubview:maskView];
    self.maskView = maskView;
    
    //创建显示label和下划线并保存进相应的数组
    for (NSInteger i = 0; i < self.itemCount; i++)
    {
        UILabel *label = [UILabel new];
        label.textAlignment = NSTextAlignmentCenter;
        label.textColor = [UIColor textColor3333];
        label.font = [UIFont qg_regularFontOfSize:30];
        [self addSubview:label];
        [self.labels addObject:label];
    }
    for (NSInteger i = 0; i < self.itemCount; i++)
    {
        UIView *line = [UIView new];
        line.backgroundColor = [UIColor lineSeparatorColorDCDC];
        [self addSubview:line];
        [self.lines addObject:line];
    }
    
    
    [self.textField becomeFirstResponder];
    
}

- (void)layoutSubviews
{
    [super layoutSubviews];
    
    if (self.labels.count != self.itemCount) return;
    //计算item的间距
    CGFloat padding = (self.bounds.size.width - self.itemWidth*self.itemCount)/(self.itemCount-1);
    //item的X坐标
    CGFloat x = 0;
    
    for (NSInteger i = 0; i < self.labels.count; i++)
    {
        x = i * (self.itemWidth + padding);
        //取出相应的label进行约束
        UILabel *label = self.labels[i];
        label.frame = CGRectMake(x, 0, self.itemWidth, self.bounds.size.height);
        UIView *line = self.lines[i];
        line.frame = CGRectMake(x, self.bounds.size.height - 0.5, self.itemWidth, 0.5);
    }
    
    self.textField.frame = self.bounds;
    self.maskView.frame = self.bounds;
}

#pragma mark - 编辑改变
- (void)tfEditingChanged:(UITextField *)textField
{
    //输入长度不超过self.itemCount
    if (textField.text.length > self.itemCount) {
        textField.text = [textField.text substringWithRange:NSMakeRange(0, self.itemCount)];
    }
    
    for (int i = 0; i < self.itemCount; i++)
    {
        UILabel *label = [self.labels objectAtIndex:i];
        UIView *line = [self.lines objectAtIndex:i];
        
        if (i < textField.text.length) {
            label.text = [textField.text substringWithRange:NSMakeRange(i, 1)];
            line.backgroundColor = [UIColor textColor6666];
        } else {
            label.text = nil;
            line.backgroundColor = [UIColor lineSeparatorColorDCDC];
        }
    }
    
    if (textField.text.length == self.itemCount) {
        //输入完成回调
        [textField resignFirstResponder];
        textField.text = [textField.text substringWithRange:NSMakeRange(0, self.itemCount)];
        if (self.codeBlock) {
            self.codeBlock(textField.text,YES);
        }
    }else{
        //正在输入的回调
        if (self.codeBlock) {
            self.codeBlock(textField.text,NO);
        }
    }
    
    
}

//开始输入
- (void)clickMaskView
{
    [self.textField becomeFirstResponder];
    if (self.codeBlock) {
        self.codeBlock(self.textField.text,NO);
    }
}

- (BOOL)endEditing:(BOOL)force
{
    [self.textField endEditing:force];
    return [super endEditing:force];
}



@end
