//
//  QGBottomLittleBtnTableViewCell.m
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/17.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//

#import "QGBottomLittleBtnTableViewCell.h"
#import "QGBasicUITool.h"
@interface QGBottomLittleBtnTableViewCell ()

@property (nonatomic, strong)UIButton *leftBtn;
@property (nonatomic, strong)UIButton *rightBtn;


@end
@implementation QGBottomLittleBtnTableViewCell


-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier leftBtnTitle:(NSString *)leftTitle rightBtnTitle:(NSString *)rightTitle
{
    if (self = [super initWithStyle:style reuseIdentifier:reuseIdentifier]) {
        
        if (![NSString isEmpty:leftTitle]) {
            self.leftBtn = [UIButton creatButtonWithSuperView:self.contentView title:leftTitle titleFont:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor3333]];
            [self.leftBtn mas_makeConstraints:^(MASConstraintMaker *make) {
               
                make.left.equalTo(self.contentView).offset(40);
                make.top.equalTo(self.contentView).offset(10);
                make.height.mas_equalTo(40);
                make.width.mas_equalTo(70);
            }];
            [self.leftBtn setContentCompressionResistancePriority:UILayoutPriorityRequired forAxis:UILayoutConstraintAxisHorizontal];
            [self.leftBtn setContentHuggingPriority:UILayoutPriorityRequired forAxis:UILayoutConstraintAxisHorizontal];
            
            [self.leftBtn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
            self.selectionStyle = UITableViewCellSelectionStyleNone;


        }
        
        if (![NSString isEmpty:rightTitle]) {
            self.rightBtn = [UIButton creatButtonWithSuperView:self.contentView title:rightTitle titleFont:[UIFont qg_regularFontOfSize:14] textColor:[UIColor textColor3333]];
            
            [self.rightBtn mas_makeConstraints:^(MASConstraintMaker *make) {
                
                make.right.equalTo(self.contentView).offset(-40);
                make.top.equalTo(self.contentView).offset(10);
                make.height.mas_equalTo(40);
                make.width.mas_equalTo(70);
            }];
            [self.rightBtn setContentCompressionResistancePriority:UILayoutPriorityRequired forAxis:UILayoutConstraintAxisHorizontal];
            [self.rightBtn setContentHuggingPriority:UILayoutPriorityRequired forAxis:UILayoutConstraintAxisHorizontal];
            
            [self.rightBtn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];

        }
        
    }
    
    return self;
}

-(void)btnClick:(UIButton *)btn
{
    
    if (self.cellBlock) {
        
        if ([btn.titleLabel.text isEqualToString:@"密码登录"]) {
            self.cellBlock(LittleBtnPasswordLogin);
        }else if ([btn.titleLabel.text isEqualToString:@"验证码登录"]){
            self.cellBlock(LittleBtnVerifyCode);
        }else{
            self.cellBlock(LittleBtnForgetPassword);
        }
    }
    
}

@end
