//
//  QGBottomLittleBtnTableViewCell.h
//  VirtualPayment
//
//  Created by 邢超 on 2019/6/17.
//  Copyright © 2019年 bo.zhang. All rights reserved.
//
typedef NS_ENUM(NSInteger,LittleBtnType){
    LittleBtnVerifyCode,  //验证码登录
    LittleBtnForgetPassword, //忘记密码
    LittleBtnPasswordLogin, // 密码登录
};

#import <UIKit/UIKit.h>

/**
 底部小按钮 cell高度60 按钮上下居中
 */
@interface QGBottomLittleBtnTableViewCell : UITableViewCell
///按钮点击的回调
@property (nonatomic, copy)void(^cellBlock)(LittleBtnType btnType);


/**
 初始化方法
 @param leftTitle 左侧按钮title，没有就传nil
 @param rightTitle 右侧按钮title，没有就传nil
 */
-(instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier leftBtnTitle:(NSString *)leftTitle rightBtnTitle:(NSString *)rightTitle;

@end
